# 📋 راهنمای کامل مرتب‌سازی پروژه

## ✅ مرحله 1: حذف فایل‌های قدیمی از هاست

این فایل‌ها رو از هاست **حذف** کن:

### فایل‌های سیستم قدیمی:
```
❌ vip_plans_handler.php
❌ install_vip_auto_system.php  
❌ test_xui_connection.php
❌ test_xui_direct.php
❌ vip_manual_config_handler.php
❌ auto_account_creator.php
❌ account_manager.php
```

### فایل‌های تست (اختیاری):
```
❌ test_broadcast.php
❌ test_features.php
❌ test_includes.php
❌ test_simple.php
❌ test.php
❌ syntax_check.php
❌ debugBot.php
❌ debug.php
```

### فایل‌های مستندات (اختیاری):
```
❌ تمام فایل‌های .md
❌ تمام فایل‌های .txt فارسی
```

---

## ✅ مرحله 2: آپلود فایل‌های جدید به هاست

این فایل‌ها رو آپلود کن:

```
✅ install_new_system.php (فایل نصب دیتابیس)
✅ server_manager.php (در مرحله بعد می‌سازیم)
✅ service_creator.php (در مرحله بعد می‌سازیم)
```

---

## ✅ مرحله 3: نصب دیتابیس جدید

1. توی مرورگر این آدرس رو باز کن:
```
https://apnlot.ir/robotali/install_new_system.php
```

2. باید این پیام رو ببینی:
```
✅ نصب با موفقیت کامل شد!
- ✅ 4 جدول ایجاد شد
- ✅ 1 سرور اضافه شد  
- ✅ 3 دسته‌بندی اضافه شد
- ✅ 8 تعرفه اضافه شد
```

---

## ✅ مرحله 4: جداول جدید در دیتابیس

این جداول اضافه شدن:

### 1️⃣ `servers` (سرورها)
- id
- name: "سرور آلمان VIP 🇩🇪"  
- server_ip: "82.115.26.209"
- panel_port: 2083
- panel_path: "/aHfvIoyNWcxlOfBfje"
- panel_username: "parisa"
- panel_password: "@230902Parisa"
- protocol: "https"
- location: "آلمان 🇩🇪"
- status: "active"

### 2️⃣ `plan_categories` (دسته‌بندی‌ها)
1. پلن‌های یک ماهه 📅
2. پلن‌های سه ماهه 📆  
3. پلن‌های شش ماهه 📊

### 3️⃣ `service_plans` (تعرفه‌ها)
**یک ماهه:**
- 20 گیگ - 40,000 تومان
- 35 گیگ - 55,000 تومان
- 50 گیگ - 70,000 تومان
- 90 گیگ - 100,000 تومان
- نامحدود - 150,000 تومان

**سه ماهه:**
- 50 گیگ - 180,000 تومان
- 100 گیگ - 270,000 تومان
- نامحدود - 400,000 تومان

### 4️⃣ `service_orders` (سفارشات)
- ذخیره اطلاعات خریدها
- لینک‌های کانفیگ
- تاریخ انقضا

---

## ✅ مرحله 5: ساختار فایل‌های نهایی پروژه

```
robotali/
├── 📄 bot.php (اصلی ربات)
├── 📄 config.php (تنظیمات)
├── 📄 baseInfo.php (اطلاعات پایه)
├── 📄 setWebhook.php
├── 📄 deleteWebhook.php
├── 📄 index.html
│
├── 🆕 install_new_system.php (نصب دیتابیس جدید)
├── 🆕 server_manager.php (مدیریت سرورها - بعداً)
├── 🆕 service_creator.php (ساخت سرویس - بعداً)
│
├── 📄 notification_system.php
├── 📄 discount_system.php
├── 📄 advanced_reports.php
├── 📄 trading_plans_handler.php
│
├── 📁 settings/
├── 📁 pay/
├── 📁 phpqrcode/
├── 📁 assets/
└── 📁 webapp/
```

---

## 🎯 مراحل بعدی (منتظر تایید شما):

1. ✅ **ساخت `server_manager.php`** - پنل مدیریت سرورها
2. ✅ **ساخت `service_creator.php`** - سیستم ساخت خودکار سرویس
3. ✅ **آپدیت `bot.php`** - منوهای جدید
4. ✅ **تست کامل سیستم**

---

## ⚠️ نکات مهم:

- ✅ فایل `vps_api_create_account.php` روی VPS بمونه (حذف نکن)
- ✅ جداول قدیمی (`vip_accounts`, `vip_account_logs`) رو نگه دار
- ✅ قبل از حذف، از همه چیز backup بگیر

---

**آماده‌ای که ادامه بدیم؟** 🚀
