<?php
/**
 * دیباگ نهایی و جامع - تست کامل سیستم فیش
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

include "config.php";

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>دیباگ نهایی سیستم</title>
    <style>
        body{font-family:Tahoma,Arial; direction:rtl; padding:20px; background:#1a1a1a; color:#e0e0e0;}
        .test{background:#263238; border-right:4px solid #2196f3; padding:20px; margin:15px 0; border-radius:5px;}
        .success{border-right-color:#4caf50; background:#1b5e20;}
        .error{border-right-color:#f44336; background:#b71c1c;}
        .warning{border-right-color:#ff9800; background:#e65100;}
        h1{color:#64b5f6; text-align:center; font-size:28px;}
        h2{color:#81c784; margin-top:25px; border-bottom:2px solid #81c784; padding-bottom:8px;}
        h3{color:#ffb74d;}
        pre{background:#000; padding:15px; border-radius:5px; overflow-x:auto; color:#aed581; font-size:12px;}
        .label{color:#90caf9; font-weight:bold;}
        .value{color:#fff59d;}
        button{padding:12px 25px; background:#2196f3; color:white; border:none; border-radius:5px; cursor:pointer; font-size:16px; margin:5px;}
        button:hover{background:#1976d2;}
        .critical{background:#d32f2f; color:white; padding:15px; border-radius:5px; font-weight:bold; margin:20px 0;}
        table{width:100%; border-collapse:collapse; margin:15px 0;}
        th,td{padding:12px; border:1px solid #424242; text-align:right;}
        th{background:#37474f; color:#81c784; font-weight:bold;}
        tr:nth-child(even){background:#212121;}
        .step-num{background:#2196f3; color:white; padding:5px 12px; border-radius:50%; display:inline-block; margin-left:10px;}
    </style>
</head>
<body>

<h1>🔥 دیباگ نهایی و جامع سیستم فیش بانکی 🔥</h1>

<?php

// ====================== تست 1: بررسی دیتابیس ======================
echo "<div class='test'>";
echo "<h2><span class='step-num'>1</span>بررسی ساختار دیتابیس</h2>";

$tables_needed = ['users', 'service_plans', 'pays', 'temp_service_purchases', 'servers'];
$all_tables_ok = true;

foreach($tables_needed as $table){
    $result = $connection->query("SHOW TABLES LIKE '{$table}'");
    if($result && $result->num_rows > 0){
        echo "<p class='label'>✅ جدول <span class='value'>{$table}</span> موجود است</p>";
        
        // بررسی ستون‌های جدول pays
        if($table == 'pays'){
            $columns = $connection->query("SHOW COLUMNS FROM pays");
            $cols = [];
            while($col = $columns->fetch_assoc()){
                $cols[] = $col['Field'];
            }
            echo "<p class='label'>ستون‌های pays:</p>";
            echo "<pre>" . implode(", ", $cols) . "</pre>";
            
            $required = ['id', 'user_id', 'hash_id', 'type', 'price', 'state', 'photo'];
            foreach($required as $req){
                if(!in_array($req, $cols)){
                    echo "<p style='color:#f44336;'>❌ ستون {$req} وجود ندارد!</p>";
                    $all_tables_ok = false;
                }
            }
        }
    } else {
        echo "<p style='color:#f44336;'>❌ جدول {$table} وجود ندارد!</p>";
        $all_tables_ok = false;
    }
}

if($all_tables_ok){
    echo "<p class='success' style='padding:10px; margin-top:15px;'>✅ ساختار دیتابیس سالم است</p>";
} else {
    echo "<div class='critical'>❌ مشکل در ساختار دیتابیس! باید رفع شود.</div>";
}
echo "</div>";

// ====================== تست 2: بررسی توابع ======================
echo "<div class='test'>";
echo "<h2><span class='step-num'>2</span>بررسی توابع ضروری</h2>";

$functions = ['bot', 'sendMessage', 'setUser', 'delMessage', 'RandomString'];
$all_functions_ok = true;

foreach($functions as $func){
    if(function_exists($func)){
        echo "<p class='label'>✅ تابع <span class='value'>{$func}()</span> موجود است</p>";
    } else {
        echo "<p style='color:#f44336;'>❌ تابع {$func}() یافت نشد!</p>";
        $all_functions_ok = false;
    }
}

if($all_functions_ok){
    echo "<p class='success' style='padding:10px; margin-top:15px;'>✅ همه توابع موجود هستند</p>";
} else {
    echo "<div class='critical'>❌ برخی توابع کلیدی وجود ندارند!</div>";
}
echo "</div>";

// ====================== تست 3: تست تابع bot() ======================
echo "<div class='test'>";
echo "<h2><span class='step-num'>3</span>تست اتصال به تلگرام (تابع bot)</h2>";

$test_result = bot('getMe', []);
if($test_result && isset($test_result->result)){
    echo "<p class='success' style='padding:10px;'>✅ اتصال به تلگرام موفق</p>";
    echo "<p class='label'>نام ربات: <span class='value'>{$test_result->result->first_name}</span></p>";
    echo "<p class='label'>یوزرنیم: <span class='value'>@{$test_result->result->username}</span></p>";
} else {
    echo "<div class='critical'>❌ اتصال به تلگرام ناموفق! مشکل در تابع bot()</div>";
    echo "<pre>" . print_r($test_result, true) . "</pre>";
}
echo "</div>";

// ====================== تست 4: پیدا کردن پلن تست ======================
echo "<div class='test'>";
echo "<h2><span class='step-num'>4</span>پیدا کردن پلن تست</h2>";

$plan_result = $connection->query("SELECT * FROM service_plans WHERE status='active' LIMIT 1");
if($plan_result && $plan_result->num_rows > 0){
    $test_plan = $plan_result->fetch_assoc();
    echo "<p class='success' style='padding:10px;'>✅ پلن تست پیدا شد</p>";
    echo "<table>";
    echo "<tr><th>فیلد</th><th>مقدار</th></tr>";
    echo "<tr><td>ID</td><td>{$test_plan['id']}</td></tr>";
    echo "<tr><td>نام</td><td>{$test_plan['name']}</td></tr>";
    echo "<tr><td>قیمت</td><td>" . number_format($test_plan['price']) . " تومان</td></tr>";
    echo "<tr><td>سرور</td><td>{$test_plan['server_id']}</td></tr>";
    echo "</table>";
    $PLAN_ID = $test_plan['id'];
} else {
    echo "<div class='critical'>❌ هیچ پلن فعالی وجود ندارد! باید اول پلن بسازید.</div>";
    echo "<p>برای ساخت پلن تست: <a href='add_sample_data.php' style='color:#64b5f6;'>کلیک کنید</a></p>";
    $PLAN_ID = null;
}
echo "</div>";

// ====================== تست 5: ساخت/پیدا کردن کاربر تست ======================
if($PLAN_ID){
    echo "<div class='test'>";
    echo "<h2><span class='step-num'>5</span>آماده‌سازی کاربر تست</h2>";
    
    $TEST_USER_ID = 8110165534; // آیدی ادمین
    
    $user_check = $connection->query("SELECT * FROM users WHERE userid={$TEST_USER_ID}");
    if(!$user_check || $user_check->num_rows == 0){
        $connection->query("INSERT INTO users (userid, name, username, step) VALUES ({$TEST_USER_ID}, 'کاربر تست', 'test_user', 'none')");
        echo "<p class='label'>✅ کاربر تست ساخته شد</p>";
    } else {
        echo "<p class='label'>✅ کاربر تست موجود است</p>";
    }
    
    echo "<p class='label'>آیدی کاربر: <span class='value'>{$TEST_USER_ID}</span></p>";
    echo "</div>";

    // ====================== تست 6: شبیه‌سازی کلیک روی "پرداخت فیش" ======================
    echo "<div class='test'>";
    echo "<h2><span class='step-num'>6</span>شبیه‌سازی دکمه 'پرداخت فیش بانکی'</h2>";
    
    $new_step = "uploadReceiptForPlan_{$PLAN_ID}";
    $connection->query("UPDATE users SET step='{$new_step}' WHERE userid={$TEST_USER_ID}");
    
    $verify = $connection->query("SELECT step FROM users WHERE userid={$TEST_USER_ID}");
    $user_data = $verify->fetch_assoc();
    
    if($user_data['step'] == $new_step){
        echo "<p class='success' style='padding:10px;'>✅ Step تنظیم شد</p>";
        echo "<p class='label'>Step فعلی: <span class='value'>{$user_data['step']}</span></p>";
    } else {
        echo "<div class='critical'>❌ Step تنظیم نشد!</div>";
    }
    echo "</div>";

    // ====================== تست 7: شبیه‌سازی ارسال فیش ======================
    echo "<div class='test'>";
    echo "<h2><span class='step-num'>7</span>شبیه‌سازی ارسال فیش (ثبت در دیتابیس)</h2>";
    
    $test_photo_id = "AgACAgQAAxkBAATest_Photo_ID_" . time();
    
    function RandomString3($length = 9) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }
    
    $hash_id = RandomString3();
    
    echo "<p class='label'>Hash ID: <span class='value'>{$hash_id}</span></p>";
    echo "<p class='label'>Photo ID: <span class='value'>{$test_photo_id}</span></p>";
    
    // ثبت در pays
    $stmt = $connection->prepare("INSERT INTO `pays` (`user_id`, `hash_id`, `type`, `price`, `state`, `photo`) VALUES (?, ?, 'SERVICE_PLAN', ?, 'pending', ?)");
    $stmt->bind_param("isis", $TEST_USER_ID, $hash_id, $test_plan['price'], $test_photo_id);
    $insert_result = $stmt->execute();
    $pay_id = $connection->insert_id;
    $stmt->close();
    
    if($insert_result){
        echo "<p class='success' style='padding:10px;'>✅ رکورد در جدول pays ثبت شد (ID: {$pay_id})</p>";
        
        // ثبت در temp
        $stmt2 = $connection->prepare("INSERT INTO `temp_service_purchases` (`hash_id`, `user_id`, `plan_id`) VALUES (?, ?, ?)");
        $stmt2->bind_param("sii", $hash_id, $TEST_USER_ID, $PLAN_ID);
        $temp_result = $stmt2->execute();
        $temp_id = $connection->insert_id;
        $stmt2->close();
        
        if($temp_result){
            echo "<p class='success' style='padding:10px;'>✅ رکورد در temp_service_purchases ثبت شد (ID: {$temp_id})</p>";
        } else {
            echo "<p style='color:#f44336;'>❌ خطا در ثبت temp: " . $connection->error . "</p>";
        }
    } else {
        echo "<div class='critical'>❌ خطا در ثبت pays: " . $connection->error . "</div>";
    }
    echo "</div>";

    // ====================== تست 8: تست ارسال پیام به کاربر ======================
    echo "<div class='test'>";
    echo "<h2><span class='step-num'>8</span>تست ارسال پیام به کاربر</h2>";
    
    $user_message = "✅ فیش شما با موفقیت ثبت شد!\n\n⏳ پس از بررسی توسط ادمین، سرویس شما فعال خواهد شد.\n\n🆔 شناسه پرداخت: <code>{$hash_id}</code>";
    
    echo "<p class='label'>متن پیام:</p>";
    echo "<pre>{$user_message}</pre>";
    
    $send_result = bot('sendMessage', [
        'chat_id' => $TEST_USER_ID,
        'text' => $user_message,
        'parse_mode' => 'HTML'
    ]);
    
    if($send_result && $send_result->ok){
        echo "<p class='success' style='padding:10px;'>✅ پیام به کاربر با موفقیت ارسال شد!</p>";
        echo "<pre>" . json_encode($send_result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    } else {
        echo "<div class='critical'>❌ ارسال پیام به کاربر ناموفق!</div>";
        echo "<p class='label'>پاسخ API:</p>";
        echo "<pre>" . json_encode($send_result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    }
    echo "</div>";

    // ====================== تست 9: تست ارسال عکس به ادمین ======================
    echo "<div class='test'>";
    echo "<h2><span class='step-num'>9</span>تست ارسال عکس به ادمین</h2>";
    
    $admin_id = 8110165534; // آیدی ادمین
    
    $price_text = number_format($test_plan['price']);
    $admin_caption = "💳 <b>فیش جدید دریافت شد</b>\n\n";
    $admin_caption .= "👤 کاربر: کاربر تست\n";
    $admin_caption .= "🆔 یوزرنیم: @test_user\n";
    $admin_caption .= "🔢 آیدی: <code>{$TEST_USER_ID}</code>\n";
    $admin_caption .= "📦 تعرفه: {$test_plan['name']}\n";
    $admin_caption .= "💰 مبلغ: {$price_text} تومان\n\n";
    $admin_caption .= "🆔 کد پیگیری: <code>{$hash_id}</code>";
    
    $admin_keyboard = [
        [['text' => '✅ تایید و ساخت سرویس', 'callback_data' => "approveServicePayment_{$hash_id}"]],
        [['text' => '❌ رد کردن', 'callback_data' => "rejectPayment_{$hash_id}"]]
    ];
    
    echo "<p class='label'>Caption:</p>";
    echo "<pre>{$admin_caption}</pre>";
    
    echo "<p class='label'>Keyboard:</p>";
    echo "<pre>" . json_encode($admin_keyboard, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    
    // استفاده از یک عکس واقعی از تلگرام (عکس لوگو تلگرام)
    $real_photo = "AgACAgQAAxkBAAIBvGZHZ8x9jKLtest"; // این باید یک file_id واقعی باشه
    
    echo "<p class='warning' style='padding:10px; background:#e65100;'>⚠️ توجه: برای تست واقعی، باید یک file_id معتبر استفاده شود</p>";
    echo "<p class='label'>راه حل: یک عکس به ربات بفرستید و file_id آن را بگیرید</p>";
    
    // تست ارسال با text به جای photo
    echo "<h3>تست 9-A: ارسال متن ساده به ادمین (بدون عکس)</h3>";
    $test_send = bot('sendMessage', [
        'chat_id' => $admin_id,
        'text' => $admin_caption,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode(['inline_keyboard' => $admin_keyboard])
    ]);
    
    if($test_send && $test_send->ok){
        echo "<p class='success' style='padding:10px;'>✅ پیام به ادمین با موفقیت ارسال شد (بدون عکس)</p>";
        echo "<pre>" . json_encode($test_send, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    } else {
        echo "<div class='critical'>❌ ارسال پیام به ادمین ناموفق!</div>";
        echo "<pre>" . json_encode($test_send, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    }
    
    echo "</div>";

    // ====================== تست 10: بررسی کد واقعی bot.php ======================
    echo "<div class='test'>";
    echo "<h2><span class='step-num'>10</span>بررسی کد uploadReceiptForPlan در bot.php</h2>";
    
    $bot_file = file_get_contents('bot.php');
    
    // بررسی وجود کد handler
    if(strpos($bot_file, "uploadReceiptForPlan") !== false){
        echo "<p class='success' style='padding:10px;'>✅ کد uploadReceiptForPlan در bot.php وجود دارد</p>";
        
        // بررسی لاگ‌ها
        if(strpos($bot_file, "error_log") !== false && strpos($bot_file, "📸 فیش دریافت شد") !== false){
            echo "<p class='success' style='padding:10px;'>✅ کدهای error_log موجود هستند</p>";
        } else {
            echo "<p class='warning' style='padding:10px; background:#e65100;'>⚠️ کدهای error_log یافت نشدند</p>";
        }
        
        // بررسی isset($photo)
        if(strpos($bot_file, "isset(\$photo)") !== false || strpos($bot_file, "!isset(\$photo)") !== false){
            echo "<p class='success' style='padding:10px;'>✅ بررسی isset(\$photo) وجود دارد</p>";
        } else {
            echo "<p class='error' style='padding:10px; background:#b71c1c;'>❌ بررسی isset(\$photo) وجود ندارد!</p>";
        }
        
    } else {
        echo "<div class='critical'>❌ کد uploadReceiptForPlan در bot.php یافت نشد!</div>";
    }
    echo "</div>";

    // ====================== نتیجه نهایی ======================
    echo "<div class='test success'>";
    echo "<h2>✅ نتیجه نهایی</h2>";
    echo "<p style='font-size:18px; font-weight:bold;'>داده‌های تست ثبت شد:</p>";
    echo "<ul style='font-size:16px; line-height:2;'>";
    echo "<li>📋 Hash ID: <code style='background:#000; padding:5px;'>{$hash_id}</code></li>";
    echo "<li>👤 User ID: <code style='background:#000; padding:5px;'>{$TEST_USER_ID}</code></li>";
    echo "<li>📦 Plan ID: <code style='background:#000; padding:5px;'>{$PLAN_ID}</code></li>";
    echo "<li>💾 Pay ID: <code style='background:#000; padding:5px;'>{$pay_id}</code></li>";
    echo "</ul>";
    
    echo "<h3 style='color:#ff9800; margin-top:25px;'>🎯 حالا تست واقعی را انجام دهید:</h3>";
    echo "<ol style='font-size:16px; line-height:2;'>";
    echo "<li>به ربات برید</li>";
    echo "<li>دکمه <b>خرید سرویس APN</b> را بزنید</li>";
    echo "<li>دسته و پلن را انتخاب کنید</li>";
    echo "<li>دکمه <b>پرداخت فیش بانکی</b> را بزنید</li>";
    echo "<li>یک عکس واقعی بفرستید (حتی یک اسکرین‌شات ساده)</li>";
    echo "</ol>";
    
    echo "<h3 style='color:#64b5f6; margin-top:25px;'>📊 بعد از ارسال عکس:</h3>";
    echo "<ul style='font-size:16px; line-height:2;'>";
    echo "<li><a href='view_logs.php' style='color:#81c784; text-decoration:none; font-weight:bold;'>→ مشاهده لاگ‌ها (view_logs.php)</a></li>";
    echo "<li><a href='debug_live.php' style='color:#81c784; text-decoration:none; font-weight:bold;'>→ بررسی وضعیت (debug_live.php)</a></li>";
    echo "<li><a href='FINAL_DEBUG.php' style='color:#81c784; text-decoration:none; font-weight:bold;'>→ تکرار این تست (FINAL_DEBUG.php)</a></li>";
    echo "</ul>";
    
    echo "</div>";
    
} else {
    echo "<div class='critical'>⛔ تست متوقف شد چون پلنی وجود ندارد!</div>";
}

?>

<div class='test' style='background:#1565c0; border-right-color:#64b5f6; margin-top:30px;'>
    <h2 style='color:white;'>📝 راهنمای عیب‌یابی</h2>
    <p style='color:#e1f5fe; font-size:16px; line-height:1.8;'>
        اگر بعد از ارسال عکس در ربات واقعی هیچ اتفاقی نیفتاد:<br><br>
        
        <b>1️⃣ چک کنید view_logs.php:</b><br>
        &nbsp;&nbsp;&nbsp;• اگر لاگی نبود → کد اصلا اجرا نشده<br>
        &nbsp;&nbsp;&nbsp;• اگر "📸 فیش دریافت شد" نبود → متغیر $photo تعریف نشده<br>
        &nbsp;&nbsp;&nbsp;• اگر "💾 فیش در دیتابیس ثبت شد" نبود → مشکل دیتابیس<br><br>
        
        <b>2️⃣ چک کنید debug_live.php:</b><br>
        &nbsp;&nbsp;&nbsp;• step باید uploadReceiptForPlan_X باشد<br>
        &nbsp;&nbsp;&nbsp;• اگر none است → دکمه پرداخت فیش کار نکرده<br><br>
        
        <b>3️⃣ بررسی webhook:</b><br>
        &nbsp;&nbsp;&nbsp;• اگر pending updates بالاست → webhook مشکل دارد<br>
        &nbsp;&nbsp;&nbsp;• باید deleteWebhook.php و دوباره setWebhook.php بزنید<br>
    </p>
</div>

</body>
</html>
