# بهینه‌سازی نمایش سرویس‌های VIP و عادی

## تغییرات انجام شده (30 نوامبر 2025)

### 1️⃣ بهبود نمایش لینک اتصال VIP (`config.php`)

**قبل:**
- لینک اتصال بدون چک نمایش داده می‌شد
- اگر لینک خیلی طولانی بود، صفحه شلوغ می‌شد
- هیچ دکمه‌ای برای عملیات روی لینک وجود نداشت

**بعد:**
- ✅ چک می‌شود اگر لینک خالی یا `0` است، پیغام واضح نمایش داده شود
- ✅ اگر لینک بیش از 80 کاراکتر است، فقط 80 کاراکتر اول + "..." نمایش داده می‌شود
- ✅ پیغام راهنما: "💡 برای مشاهده کامل روی دکمه زیر کلیک کنید"
- ✅ دکمه‌های جدید اضافه شد:
  - 🔗 **مشاهده لینک کامل** - نمایش لینک در پیام جدید
  - 📷 **QR کد** - تولید QR کد از لینک
  - 📱 **راهنمای اتصال** - راهنمای نصب برنامه‌ها

### 2️⃣ Handler نمایش لینک کامل VIP (`bot.php`)

**کالبک:** `viewVipLink_{order_id}`

**عملکرد:**
- دریافت اطلاعات سرویس از `orders_list`
- چک کردن وجود لینک
- نمایش لینک کامل در پیام جدید با فرمت زیبا
- دکمه‌های: QR کد، راهنمای نصب، بازگشت

**مثال خروجی:**
```
🔗 لینک اتصال کامل

📦 سرویس: نامحدود تک کاربره یک ماهه

━━━━━━━━━━━━━━━━━━

vless://abc123...

━━━━━━━━━━━━━━━━━━

💡 نحوه استفاده:
۱. لینک بالا را کپی کنید (کلیک روی لینک)
۲. در برنامه v2rayNG یا مشابه وارد کنید
۳. روی Connect کلیک کنید
```

### 3️⃣ Handler تولید QR کد VIP (`bot.php`)

**کالبک:** `getVipQR_{order_id}`

**عملکرد:**
- استفاده از کتابخانه `phpqrcode` موجود در پروژه
- تولید تصویر QR در مسیر: `phpqrcode/temp/vip_qr_{id}_{timestamp}.png`
- ارسال تصویر با `sendPhoto()` + کپشن توضیحی
- دکمه‌های: مشاهده لینک کامل، راهنمای نصب، بازگشت

**تنظیمات QR:**
- سطح تصحیح خطا: `QR_ECLEVEL_L` (کم‌ترین - سریع‌ترین)
- اندازه: `6` (متوسط)
- حاشیه: `2` پیکسل

### 4️⃣ بهبود لیست سرویس‌ها (`bot.php` - سیستم myServices)

**قبل:**
```
[📱 مشاهده سرویس #1]
```

**بعد:**
```
[📱 مشاهده سرویس #1] [🔗 لینک]
```

- ✅ دکمه لینک فقط در صورت وجود کانفیگ نمایش داده می‌شود
- ✅ دو دکمه در یک ردیف = دسترسی سریع‌تر

### 5️⃣ QR کد برای سرویس‌های عادی

**کالبک:** `getConfigQR_{service_id}`

- همان عملکرد QR برای سرویس‌های جدید (service_orders)
- ذخیره در: `phpqrcode/temp/qr_{id}_{timestamp}.png`

---

## فایل‌های ویرایش شده

1. ✅ `config.php` (خط 1608-1677) - تابع `getOrderDetailKeys()` برای VIP
2. ✅ `bot.php` - اضافه شدن:
   - Handler `viewVipLink_{id}` (خط ~10513)
   - Handler `getVipQR_{id}` (خط ~10563)
   - Handler `getConfigQR_{id}` (خط ~10470)
   - بهبود لیست myServices (خط ~10310)

---

## نکات تکمیلی

### پاکسازی فایل‌های QR موقت
فعلاً فایل‌های QR در `phpqrcode/temp/` باقی می‌مانند. برای پاکسازی خودکار می‌توانید:

**روش 1: حذف بعد از ارسال (سریع اما ممکن است خطا دهد)**
```php
sendPhoto($botUrl . $filename, $caption, ...);
@unlink($filepath); // حذف فایل
```

**روش 2: Cron Job روزانه (پیشنهادی)**
```bash
# در crontab اضافه کنید:
0 3 * * * find /path/to/robotali/phpqrcode/temp/ -name "*.png" -mtime +1 -delete
```

**روش 3: پاکسازی در شروع اسکریپت**
```php
// در ابتدای bot.php
$old_files = glob(__DIR__ . '/phpqrcode/temp/*.png');
foreach($old_files as $file){
    if(time() - filemtime($file) > 86400) @unlink($file); // فایل‌های بیش از 1 روز
}
```

### بهبودهای آینده (اختیاری)

1. **نمایش ترافیک مصرفی:**
   - اتصال به API پنل
   - خواندن `up` و `down` از سرور
   - نمایش در جزئیات سرویس

2. **دکمه تمدید سریع:**
   - اگر سرویس نزدیک انقضا باشد
   - لینک مستقیم به صفحه خرید

3. **اعلان‌های هوشمند:**
   - 7 روز قبل انقضا
   - 3 روز قبل انقضا
   - 24 ساعت قبل انقضا

---

## تست کردن

### تست 1: نمایش لینک VIP
1. وارد ربات شوید
2. روی "سرویس‌های من" کلیک کنید
3. یک سرویس VIP انتخاب کنید
4. روی "🔗 مشاهده لینک کامل" کلیک کنید
5. بررسی کنید لینک کامل نمایش داده شود

### تست 2: QR کد VIP
1. در همان صفحه سرویس
2. روی "📷 QR کد" کلیک کنید
3. بررسی کنید تصویر QR ارسال شود
4. با اسکنر QR تست کنید

### تست 3: لیست سرویس‌ها
1. در "سرویس‌های من"
2. بررسی کنید دکمه "🔗 لینک" کنار هر سرویس وجود دارد
3. کلیک کنید و لینک دریافت شود

---

## پشتیبانی

اگر مشکلی پیش آمد:
1. لاگ‌ها را چک کنید: `settings/error_log`
2. مجوز نوشتن روی پوشه `phpqrcode/temp/` را بررسی کنید:
   ```bash
   chmod 755 phpqrcode/temp/
   ```
3. بررسی کنید کتابخانه GD نصب باشد:
   ```bash
   php -m | grep gd
   ```

---

**تاریخ:** 30 نوامبر 2025  
**نسخه:** 1.0  
**توسعه‌دهنده:** GitHub Copilot
