<?php
// لاگ کامل تمام درخواست‌ها
$logFile = 'request_log.txt';
$time = date('Y-m-d H:i:s');

// دریافت ورودی
$input = file_get_contents('php://input');

// ذخیره در لاگ
$log = "\n=== $time ===\n";
$log .= "Method: " . ($_SERVER['REQUEST_METHOD'] ?? 'UNKNOWN') . "\n";
$log .= "IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN') . "\n";
$log .= "Input Length: " . strlen($input) . "\n";
$log .= "Input: " . $input . "\n";

if(!empty($input)) {
    $update = json_decode($input, true);
    $log .= "Decoded:\n" . print_r($update, true) . "\n";
}

$log .= "PHP Errors: " . error_get_last()['message'] ?? 'None' . "\n";
$log .= "================================\n";

file_put_contents($logFile, $log, FILE_APPEND);

// اکنون اجرای bot.php
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/bot_execution_errors.log');

try {
    include 'bot.php';
    file_put_contents($logFile, "✅ bot.php executed successfully\n", FILE_APPEND);
} catch (Throwable $e) {
    $error = "❌ Error: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine() . "\n";
    file_put_contents($logFile, $error, FILE_APPEND);
    file_put_contents('bot_execution_errors.log', $error . "\n" . $e->getTraceAsString() . "\n", FILE_APPEND);
}

// ثبت اتمام
file_put_contents($logFile, "Script completed at " . date('H:i:s') . "\n", FILE_APPEND);

// پاسخ 200 به تلگرام
http_response_code(200);
?>
