<?php
// بررسی خطاهای PHP در bot.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 بررسی خطاهای PHP</h2>";
echo "<hr>";

// 1. بررسی syntax فایل bot.php
echo "<h3>1️⃣ بررسی Syntax</h3>";
$output = shell_exec('php -l bot.php 2>&1');
if(strpos($output, 'No syntax errors') !== false) {
    echo "✅ خطای syntax وجود ندارد<br>";
} else {
    echo "❌ خطای syntax:<br><pre>$output</pre>";
}
echo "<hr>";

// 2. تست اجرای bot.php با ورودی فیک
echo "<h3>2️⃣ تست اجرای bot.php</h3>";

// ساخت ورودی تست
$testUpdate = json_encode([
    'update_id' => 123456789,
    'message' => [
        'message_id' => 1,
        'from' => [
            'id' => 8110165534,
            'is_bot' => false,
            'first_name' => 'Test',
            'username' => 'test'
        ],
        'chat' => [
            'id' => 8110165534,
            'first_name' => 'Test',
            'type' => 'private'
        ],
        'date' => time(),
        'text' => '/start'
    ]
]);

// ذخیره ورودی تست
file_put_contents('test_input.json', $testUpdate);

// اجرای bot.php با ورودی تست
ob_start();
$_SERVER['REQUEST_METHOD'] = 'POST';
file_put_contents('php://input', $testUpdate);

try {
    include 'bot.php';
    $output = ob_get_clean();
    echo "✅ bot.php اجرا شد بدون خطای Fatal<br>";
    if(!empty($output)) {
        echo "<strong>خروجی:</strong><pre>$output</pre>";
    }
} catch (Exception $e) {
    $output = ob_get_clean();
    echo "❌ خطای Exception:<br>";
    echo "<pre>" . $e->getMessage() . "</pre>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    if(!empty($output)) {
        echo "<strong>خروجی قبل از خطا:</strong><pre>$output</pre>";
    }
}
echo "<hr>";

// 3. بررسی error_log
echo "<h3>3️⃣ بررسی Error Log</h3>";
$error_log = 'settings/error_log';
if(file_exists($error_log)) {
    $errors = file_get_contents($error_log);
    if(!empty($errors)) {
        // نمایش 50 خط آخر
        $lines = explode("\n", $errors);
        $last_lines = array_slice($lines, -50);
        echo "<pre>" . implode("\n", $last_lines) . "</pre>";
    } else {
        echo "✅ لاگ خطا خالی است<br>";
    }
} else {
    echo "⚠️ فایل error_log وجود ندارد<br>";
}
echo "<hr>";

// 4. بررسی تمام فایل‌های include شده
echo "<h3>4️⃣ بررسی فایل‌های Include</h3>";
$includes = [
    'config.php',
    'server_manager.php',
    'service_creator.php',
    'trading_plans_handler.php',
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php'
];

foreach($includes as $file) {
    if(file_exists($file)) {
        $check = shell_exec("php -l $file 2>&1");
        if(strpos($check, 'No syntax errors') !== false) {
            echo "✅ $file<br>";
        } else {
            echo "❌ $file - خطای syntax:<br><pre>$check</pre>";
        }
    } else {
        echo "❌ $file - فایل وجود ندارد<br>";
    }
}

echo "<hr>";
echo "<h3>💡 نتیجه</h3>";
echo "<p>خطاهای بالا را بررسی کنید</p>";
?>
