<?php
// بررسی Syntax تمام فایل‌ها
echo "<html><head><meta charset='utf-8'></head><body>";
echo "<h1>🔍 بررسی Syntax فایل‌های PHP</h1>";
echo "<hr>";

$files = [
    'bot.php',
    'config.php',
    'baseInfo.php',
    'settings/values.php',
    'server_manager.php',
    'service_creator.php',
    'trading_plans_handler.php',
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php'
];

$hasError = false;

foreach($files as $file) {
    if(!file_exists($file)) {
        echo "❌ <strong>$file</strong> - فایل وجود ندارد<br>";
        continue;
    }
    
    $output = shell_exec("php -l \"$file\" 2>&1");
    
    if(strpos($output, 'No syntax errors') !== false) {
        echo "✅ <strong>$file</strong> - بدون خطا<br>";
    } else {
        echo "❌ <strong>$file</strong> - خطای Syntax:<br>";
        echo "<pre style='background:#ffcccc;padding:10px;border-radius:5px;'>$output</pre>";
        $hasError = true;
    }
}

echo "<hr>";

if($hasError) {
    echo "<h2 style='color:red;'>⚠️ خطا پیدا شد! فایل‌های بالا را بررسی کنید</h2>";
} else {
    echo "<h2 style='color:green;'>✅ همه فایل‌ها syntax صحیح دارند</h2>";
    echo "<p>مشکل احتمالاً از Runtime است. برای بررسی دقیق‌تر:</p>";
    echo "<a href='full_debug.php' style='background:#007bff;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>🧪 اجرای تست Runtime</a> ";
    echo "<a href='view_logs.php' style='background:#dc3545;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>📋 مشاهده لاگ خطاها</a>";
}

echo "</body></html>";
?>
