<?php
/**
 * Cron Job برای نوتیفیکیشن‌های خودکار
 * این فایل باید هر 6 ساعت یکبار اجرا شود
 * 
 * نحوه تنظیم در cPanel:
 * 0 */6 * * * /usr/bin/php /home/username/public_html/cron_notifications.php
 * 
 * یا برای اجرای دستی:
 * https://lotfisch.ir/cron_notifications.php?key=YOUR_SECRET_KEY
 */

// کلید امنیتی - حتماً تغییر دهید!
define('CRON_SECRET_KEY', 'APN_CRON_2025_SECRET_KEY');

// بررسی کلید امنیتی
if(php_sapi_name() !== 'cli') {
    // اگر از مرورگر اجرا می‌شود
    if(!isset($_GET['key']) || $_GET['key'] !== CRON_SECRET_KEY) {
        http_response_code(403);
        die('⛔ Access Denied');
    }
}

// لاگ فایل
$log_file = __DIR__ . '/cron_log.txt';

function writeLog($message) {
    global $log_file;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($log_file, "[$timestamp] $message\n", FILE_APPEND);
    echo "[$timestamp] $message\n";
}

writeLog("🤖 شروع Cron Job نوتیفیکیشن‌ها");

try {
    include_once 'notification_system.php';
    
    // چک سرویس‌های در حال اتمام
    writeLog("📋 چک سرویس‌های در حال اتمام...");
    $result1 = checkExpiringServices();
    writeLog($result1);
    
    // چک سرویس‌های منقضی شده
    writeLog("📋 چک سرویس‌های منقضی شده...");
    $result2 = checkExpiredServices();
    writeLog($result2);
    
    writeLog("✅ Cron Job با موفقیت اجرا شد");
    
} catch (Exception $e) {
    writeLog("❌ خطا: " . $e->getMessage());
}

writeLog("━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━");
?>
