<?php
// نمایش خطاهای دقیق
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<pre>";
echo "=== تست bot.php ===\n\n";

// تست به صورت مرحله به مرحله
echo "مرحله 1: لود baseInfo.php\n";
if(file_exists('baseInfo.php')) {
    include_once 'baseInfo.php';
    echo "✅ baseInfo.php لود شد\n\n";
} else {
    die("❌ baseInfo.php یافت نشد!\n");
}

echo "مرحله 2: لود config.php\n";
if(file_exists('config.php')) {
    try {
        include_once 'config.php';
        echo "✅ config.php لود شد\n\n";
    } catch(Exception $e) {
        echo "❌ خطا در config.php:\n";
        echo $e->getMessage() . "\n\n";
        die();
    }
} else {
    die("❌ config.php یافت نشد!\n");
}

echo "مرحله 3: بررسی اتصال دیتابیس\n";
if(isset($connection) && $connection->ping()) {
    echo "✅ اتصال به دیتابیس برقرار است\n\n";
} else {
    echo "❌ اتصال به دیتابیس برقرار نیست\n";
    if(isset($connection)) {
        echo "خطا: " . $connection->error . "\n\n";
    }
}

echo "مرحله 4: بررسی متغیرهای مهم\n";
$vars = ['botToken', 'admin', 'from_id', 'text', 'data'];
foreach($vars as $var) {
    if(isset($$var)) {
        if($var == 'botToken') {
            echo "✅ $var: " . substr($$var, 0, 20) . "...\n";
        } else {
            echo "✅ $var: " . $$var . "\n";
        }
    } else {
        echo "⚠️ $var: تنظیم نشده\n";
    }
}

echo "\n";
echo "مرحله 5: شبیه‌سازی درخواست تلگرام\n";
$_POST['update'] = json_encode([
    'message' => [
        'message_id' => 1,
        'from' => [
            'id' => $admin,
            'first_name' => 'Test',
            'username' => 'test'
        ],
        'chat' => [
            'id' => $admin,
            'type' => 'private'
        ],
        'text' => '/start'
    ]
]);

echo "✅ درخواست تست ایجاد شد\n\n";

echo "مرحله 6: تلاش برای اجرای bot.php\n";
echo "توجه: اگر خطایی وجود داشته باشد، در زیر نمایش داده می‌شود:\n";
echo str_repeat("-", 50) . "\n";

// تلاش برای include
ob_start();
try {
    // شبیه‌سازی ورودی تلگرام
    file_put_contents('php://input', json_encode([
        'message' => [
            'message_id' => 1,
            'from' => [
                'id' => $admin,
                'first_name' => 'Test',
                'username' => 'test'
            ],
            'chat' => [
                'id' => $admin,
                'type' => 'private'
            ],
            'text' => '/start'
        ]
    ]));
    
    include 'bot.php';
    echo "\n✅ bot.php بدون خطا اجرا شد!\n";
} catch(Error $e) {
    echo "\n❌ خطای Fatal:\n";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
    echo "\nStack Trace:\n" . $e->getTraceAsString() . "\n";
} catch(Exception $e) {
    echo "\n❌ خطا:\n";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
}
$output = ob_get_clean();

echo str_repeat("-", 50) . "\n";
if(!empty($output)) {
    echo $output;
} else {
    echo "هیچ خروجی وجود ندارد\n";
}

echo "\n\n=== پایان تست ===\n";
echo "</pre>";
?>
