<?php
/**
 * فایل دیباگ برای تست callback_data
 * این فایل رو اجرا کنید و بعد دکمه پلن رو بزنید
 */

include_once 'config.php';

// فعال کردن نمایش خطاها
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🐛 دیباگ کلیک روی پلن</h1>";
echo "<hr>";

echo "<p style='color:orange;'>⚠️ این فایل فقط زمانی کار می‌کنه که webhook غیرفعال باشه.</p>";
echo "<p>برای دیباگ دقیق‌تر، از فایل <a href='quick_test.php'>quick_test.php</a> استفاده کنید.</p>";
echo "<hr>";

// بررسی ساده تعرفه‌ها
echo "<h2>📦 لیست تعرفه‌های فعال:</h2>";

$stmt = $connection->prepare("SELECT sp.id, sp.name, pc.name as category_name 
                               FROM service_plans sp 
                               JOIN plan_categories pc ON sp.category_id = pc.id 
                               WHERE sp.status = 'active' 
                               LIMIT 10");
$stmt->execute();
$plans = $stmt->get_result();
$stmt->close();

if($plans->num_rows > 0){
    echo "<ul>";
    while($plan = $plans->fetch_assoc()){
        echo "<li>ID: {$plan['id']} - {$plan['name']} ({$plan['category_name']})</li>";
    }
    echo "</ul>";
    echo "<p style='color:green;'>✅ تعرفه‌ها موجودند</p>";
} else {
    echo "<p style='color:red;'>❌ هیچ تعرفه‌ای یافت نشد!</p>";
}

echo "<hr>";
echo "<h2>🔧 برای تست کامل:</h2>";
echo "<ol>";
echo "<li><a href='quick_test.php'>فایل تست سریع</a> - تست کامل سیستم</li>";
echo "<li><a href='test_buy_flow.php'>بررسی جریان خرید</a> - چک کردن داده‌ها</li>";
echo "<li>یا مستقیم در ربات تست کنید</li>";
echo "</ol>";

echo "<li>یا مستقیم در ربات تست کنید</li>";
echo "</ol>";

echo "<hr>";
echo "<p style='text-align:center; color:#666;'>تاریخ: " . date('Y-m-d H:i:s') . "</p>";
?>
