<?php
// فایل debug - این فایل برای بررسی درخواست‌های ورودی است
include_once 'baseInfo.php';

// دریافت ورودی
$update = file_get_contents('php://input');
$updateArray = json_decode($update, true);

// ذخیره در فایل لاگ
$logFile = 'debug_log.txt';
$time = date('Y-m-d H:i:s');
$logContent = "=== $time ===\n";
$logContent .= "Raw Input:\n" . $update . "\n";
$logContent .= "Parsed:\n" . print_r($updateArray, true) . "\n";
$logContent .= "================================\n\n";

file_put_contents($logFile, $logContent, FILE_APPEND);

// نمایش در مرورگر
echo "<pre>";
echo "🔍 Debug Mode\n";
echo "=================\n\n";
echo "زمان: $time\n\n";

if(empty($update)) {
    echo "⚠️ هیچ داده‌ای دریافت نشد\n";
    echo "این فایل باید توسط تلگرام فراخوانی شود\n\n";
    echo "برای تست:\n";
    echo "1. این فایل را به عنوان webhook تنظیم کنید\n";
    echo "2. در تلگرام به ربات پیام دهید\n";
    echo "3. این صفحه را رفرش کنید\n";
} else {
    echo "✅ داده دریافت شد:\n\n";
    print_r($updateArray);
}

echo "\n\nلاگ ذخیره شد در: $logFile\n";
echo "</pre>";

// پاسخ موفق به تلگرام
http_response_code(200);
?>
