<?php
/**
 * سیستم کد تخفیف پیشرفته
 * مدیریت کدهای تخفیف با قابلیت‌های حرفه‌ای
 */

include_once 'config.php';

// ===============================
// ایجاد کد تخفیف جدید (ادمین)
// ===============================
if($data == 'createDiscount' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    delMessage();
    sendMessage("🎁 ایجاد کد تخفیف جدید

لطفا نام کد تخفیف را وارد کنید:
مثال: WELCOME10, SUMMER2025, VIP50

⚠️ فقط حروف انگلیسی و اعداد", $cancelKey);
    setUser('createDiscountCode');
    exit;
}

if($userInfo['step'] == 'createDiscountCode' && $text != $buttonValues['cancel'] && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    // بررسی فرمت
    if(!preg_match('/^[A-Z0-9]+$/', $text)){
        sendMessage("❌ فقط از حروف بزرگ انگلیسی و اعداد استفاده کنید!", $cancelKey);
        exit;
    }
    
    // چک تکراری نبودن
    $stmt = $connection->prepare("SELECT * FROM `discounts` WHERE `code` = ?");
    $stmt->bind_param("s", $text);
    $stmt->execute();
    $existing = $stmt->get_result();
    $stmt->close();
    
    if($existing->num_rows > 0){
        sendMessage("❌ این کد قبلاً ثبت شده! لطفا کد دیگری انتخاب کنید", $cancelKey);
        exit;
    }
    
    setUser('discountType_' . $text);
    sendMessage("✅ کد تخفیف: <code>$text</code>

حالا نوع تخفیف را انتخاب کنید:", json_encode([
        'inline_keyboard' => [
            [['text' => '💰 مبلغ ثابت (مثلا 10,000 تومان)', 'callback_data' => 'discountTypeFixed']],
            [['text' => '📊 درصدی (مثلا 20%)', 'callback_data' => 'discountTypePercent']],
            [['text' => '❌ انصراف', 'callback_data' => 'mainMenu']]
        ]
    ]), 'HTML');
    exit;
}

if($data == 'discountTypeFixed' && preg_match('/^discountType_(.+)/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $code = $match[1];
    setUser("discountAmount_{$code}_fixed");
    delMessage();
    sendMessage("💰 کد تخفیف: <code>$code</code>

مبلغ تخفیف را به تومان وارد کنید:
مثال: 10000 (ده هزار تومان)", $cancelKey, 'HTML');
    exit;
}

if($data == 'discountTypePercent' && preg_match('/^discountType_(.+)/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $code = $match[1];
    setUser("discountAmount_{$code}_percent");
    delMessage();
    sendMessage("📊 کد تخفیف: <code>$code</code>

درصد تخفیف را وارد کنید (1 تا 100):
مثال: 20", $cancelKey, 'HTML');
    exit;
}

if(preg_match('/^discountAmount_(.+)_(fixed|percent)$/', $userInfo['step'], $match) && $text != $buttonValues['cancel'] && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $code = $match[1];
    $type = $match[2];
    
    if(!is_numeric($text) || $text <= 0){
        sendMessage("❌ لطفا یک عدد معتبر وارد کنید!", $cancelKey);
        exit;
    }
    
    if($type == 'percent' && $text > 100){
        sendMessage("❌ درصد تخفیف نمی‌تواند بیشتر از 100 باشد!", $cancelKey);
        exit;
    }
    
    setUser("discountExpireDate_{$code}_{$type}_{$text}");
    sendMessage("📅 کد تخفیف: <code>$code</code>
نوع: " . ($type == 'fixed' ? 'مبلغ ثابت' : 'درصدی') . "
مقدار: " . number_format($text) . ($type == 'fixed' ? ' تومان' : '%') . "

تا چند روز دیگر معتبر باشد؟
مثال: 7 (یک هفته)، 30 (یک ماه)، 0 (نامحدود)", $cancelKey, 'HTML');
    exit;
}

if(preg_match('/^discountExpireDate_(.+)_(.+)_(.+)$/', $userInfo['step'], $match) && $text != $buttonValues['cancel'] && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $code = $match[1];
    $type = $match[2];
    $amount = $match[3];
    
    if(!is_numeric($text) || $text < 0){
        sendMessage("❌ لطفا یک عدد معتبر وارد کنید!", $cancelKey);
        exit;
    }
    
    $expire_date = $text == 0 ? 0 : (time() + ($text * 24 * 60 * 60));
    
    setUser("discountUsageLimit_{$code}_{$type}_{$amount}_{$expire_date}");
    sendMessage("🔢 کد تخفیف: <code>$code</code>

حداکثر تعداد استفاده:
مثال: 100 (صد نفر)، 0 (نامحدود)", $cancelKey, 'HTML');
    exit;
}

if(preg_match('/^discountUsageLimit_(.+)_(.+)_(.+)_(.+)$/', $userInfo['step'], $match) && $text != $buttonValues['cancel'] && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $code = $match[1];
    $type = $match[2];
    $amount = $match[3];
    $expire_date = $match[4];
    
    if(!is_numeric($text) || $text < 0){
        sendMessage("❌ لطفا یک عدد معتبر وارد کنید!", $cancelKey);
        exit;
    }
    
    // ذخیره در دیتابیس
    $status = 'active';
    $stmt = $connection->prepare("INSERT INTO `discounts` (`code`, `type`, `amount`, `expire_date`, `max_use`, `status`) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssiiss", $code, $type, $amount, $expire_date, $text, $status);
    $stmt->execute();
    $stmt->close();
    
    setUser('none');
    
    $summary = "✅ کد تخفیف با موفقیت ایجاد شد!

━━━━━━━━━━━━━━━━━━━━━━
🎁 <b>مشخصات کد تخفیف</b>
━━━━━━━━━━━━━━━━━━━━━━

📝 کد: <code>$code</code>
💰 نوع: " . ($type == 'fixed' ? 'مبلغ ثابت' : 'درصدی') . "
🎯 مقدار: " . number_format($amount) . ($type == 'fixed' ? ' تومان' : '%') . "
📅 انقضا: " . ($expire_date == 0 ? 'نامحدود' : jdate('Y/m/d', $expire_date)) . "
🔢 تعداد: " . ($text == 0 ? 'نامحدود' : number_format($text) . ' بار') . "

━━━━━━━━━━━━━━━━━━━━━━

کاربران می‌توانند این کد را هنگام خرید وارد کنند.";
    
    sendMessage($summary, getAdminKeys(), 'HTML');
    exit;
}

// ===============================
// لیست کدهای تخفیف (ادمین)
// ===============================
if($data == 'listDiscounts' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT * FROM `discounts` WHERE `status` = 'active' ORDER BY `id` DESC");
    $stmt->execute();
    $discounts = $stmt->get_result();
    $stmt->close();
    
    if($discounts->num_rows == 0){
        editText($message_id, "📭 هیچ کد تخفیف فعالی وجود ندارد!", json_encode([
            'inline_keyboard' => [
                [['text' => '➕ ایجاد کد تخفیف', 'callback_data' => 'createDiscount']],
                [['text' => '🔙 بازگشت', 'callback_data' => 'managePanel']]
            ]
        ]));
        exit;
    }
    
    $message = "🎁 لیست کدهای تخفیف فعال:\n\n";
    $keyboard = [];
    
    while($discount = $discounts->fetch_assoc()){
        $used_count = $discount['used_count'];
        $type_label = $discount['type'] == 'fixed' ? '💰' : '📊';
        $amount_label = $discount['type'] == 'fixed' ? number_format($discount['amount']) . ' تومان' : $discount['amount'] . '%';
        
        $message .= "━━━━━━━━━━━━━━━━━━━━\n";
        $message .= "📝 کد: <code>{$discount['code']}</code>\n";
        $message .= "{$type_label} تخفیف: {$amount_label}\n";
        $message .= "👥 استفاده شده: {$used_count}";
        if($discount['max_use'] > 0) $message .= " / {$discount['max_use']}";
        $message .= "\n";
        if($discount['expire_date'] > 0){
            $message .= "📅 انقضا: " . jdate('Y/m/d', $discount['expire_date']) . "\n";
        }
        $message .= "\n";
        
        $keyboard[] = [
            ['text' => "🗑 حذف {$discount['code']}", 'callback_data' => "deleteDiscount_{$discount['id']}"],
            ['text' => "📊 آمار", 'callback_data' => "discountStats_{$discount['id']}"]
        ];
    }
    
    $keyboard[] = [['text' => '➕ ایجاد کد جدید', 'callback_data' => 'createDiscount']];
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'managePanel']];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// ===============================
// حذف کد تخفیف
// ===============================
if(preg_match('/^deleteDiscount_(\d+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $status = 'inactive';
    $stmt = $connection->prepare("UPDATE `discounts` SET `status` = ? WHERE `id` = ?");
    $stmt->bind_param("si", $status, $match[1]);
    $stmt->execute();
    $stmt->close();
    
    alert("✅ کد تخفیف غیرفعال شد");
    
    // بازگشت به لیست
    $data = 'listDiscounts';
    goto list_discounts_label;
}

list_discounts_label:

// ===============================
// استفاده از کد تخفیف (کاربر)
// ===============================
if($data == 'useDiscountCode'){
    delMessage();
    sendMessage("🛍 <b>خرید سرویس</b>

💡 اگر کد تخفیف دارید، ابتدا وارد کنید:
(اگر ندارید فقط بزنید /start)

مثال کد تخفیف: <code>WELCOME10</code>", $cancelKey, 'HTML');
    setUser('applyDiscountCode');
    exit;
}

// اگر در حالت applyDiscountCode انصراف بزنه، به منوی سرویس‌ها بره
if($userInfo['step'] == 'applyDiscountCode' && $text == $buttonValues['cancel']){
    setUser('none');
    setUser('', 'temp');
    sendMessage("✅ انتخاب سرویس:

🛍 یکی از گزینه‌های زیر را انتخاب کنید:

💡 راهنما:
🔥 پلن VIP: اشتراک پرسرعت با ترافیک بالا
📈 پلن Trading: برای معامله‌گری ارزهای دیجیتال", json_encode([
        'inline_keyboard' => [
            [['text' => '🔥 پلن‌های VIP', 'callback_data' => 'vipPlans']],
            [['text' => '📈 پلن‌های Trading', 'callback_data' => 'tradingPlans']],
            [['text' => '🏘 صفحه اصلی', 'callback_data' => 'mainMenu']]
        ]
    ]), 'HTML', null, null);
    exit;
}

if($userInfo['step'] == 'applyDiscountCode' && $text != $buttonValues['cancel']){
    // اگر /start زده، بدون کد تخفیف بره انتخاب سرویس
    if(preg_match('/^\/start/i', $text)){
        setUser('none');
        setUser('', 'temp');
        sendMessage("✅ انتخاب سرویس بدون کد تخفیف:

🛍 یکی از گزینه‌های زیر را انتخاب کنید:

💡 راهنما:
🔥 پلن VIP: اشتراک پرسرعت با ترافیک بالا
📈 پلن Trading: برای معامله‌گری ارزهای دیجیتال", json_encode([
            'inline_keyboard' => [
                [['text' => '🔥 پلن‌های VIP', 'callback_data' => 'vipPlans']],
                [['text' => '📈 پلن‌های Trading', 'callback_data' => 'tradingPlans']],
                [['text' => '🏘 صفحه اصلی', 'callback_data' => 'mainMenu']]
            ]
        ]), 'HTML');
        exit;
    }
    
    $code = strtoupper(trim($text));
    
    // بررسی وجود کد
    $stmt = $connection->prepare("SELECT * FROM `discounts` WHERE `code` = ? AND `status` = 'active'");
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $discount = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$discount){
        sendMessage("❌ کد تخفیف نامعتبر است!", $cancelKey);
        exit;
    }
    
    // بررسی انقضا
    if($discount['expire_date'] > 0 && $discount['expire_date'] < time()){
        sendMessage("❌ این کد تخفیف منقضی شده است!", $cancelKey);
        exit;
    }
    
    // بررسی تعداد استفاده
    if($discount['max_use'] > 0 && $discount['used_count'] >= $discount['max_use']){
        sendMessage("❌ ظرفیت این کد تخفیف تکمیل شده است!", $cancelKey);
        exit;
    }
    
    // بررسی استفاده قبلی این کاربر
    $stmt = $connection->prepare("SELECT * FROM `discount_usage` WHERE `user_id` = ? AND `discount_id` = ?");
    $stmt->bind_param("ii", $from_id, $discount['id']);
    $stmt->execute();
    $previous_use = $stmt->get_result();
    $stmt->close();
    
    if($previous_use->num_rows > 0){
        sendMessage("❌ شما قبلاً از این کد استفاده کرده‌اید!", $cancelKey);
        exit;
    }
    
    // ذخیره کد در temp کاربر و حالا نمایش سرویس‌ها برای انتخاب
    setUser($code, 'temp');
    setUser('none'); // reset step
    
    $discount_text = $discount['type'] == 'fixed' 
        ? number_format($discount['amount']) . ' تومان' 
        : $discount['amount'] . '%';
    
    sendMessage("✅ کد تخفیف معتبر است!

━━━━━━━━━━━━━━━━━━━━━━
🎁 <b>تخفیف شما: $discount_text</b>
━━━━━━━━━━━━━━━━━━━━━━

حالا یکی از سرویس‌های زیر را انتخاب کنید:

💡 راهنما:
🔥 پلن VIP: اشتراک پرسرعت با ترافیک بالا
📈 پلن Trading: برای معامله‌گری ارزهای دیجیتال

💰 تخفیف به صورت خودکار در زمان پرداخت اعمال می‌شود.", json_encode([
        'inline_keyboard' => [
            [['text' => '🔥 پلن‌های VIP', 'callback_data' => 'vipPlans']],
            [['text' => '📈 پلن‌های Trading', 'callback_data' => 'tradingPlans']],
            [['text' => '🏘 صفحه اصلی', 'callback_data' => 'mainMenu']]
        ]
    ]), 'HTML', null, null);
    exit;
}

// انتخاب پلن VIP با کد تخفیف
if($data == 'vipPlansWithDiscount'){
    // تغییر data به vipPlans تا کد در vip_plans_handler اجرا شود
    // کد تخفیف در temp ذخیره شده و در زمان پرداخت اعمال خواهد شد
    $data = 'vipPlans';
    // اجازه ادامه به vip_plans_handler.php
}

/**
 * اعمال تخفیف به قیمت
 * این تابع باید قبل از ثبت پرداخت فراخوانی شود
 */
function applyDiscount($user_id, $original_price, $plan_id = 0) {
    global $connection;
    
    // بررسی کد تخفیف در temp
    $stmt = $connection->prepare("SELECT `temp` FROM `users` WHERE `userid` = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(empty($user['temp'])) {
        return ['price' => $original_price, 'discount' => 0, 'code' => null, 'original_price' => $original_price, 'discount_id' => null];
    }
    
    $code = $user['temp'];
    
    // دریافت اطلاعات تخفیف
    $stmt = $connection->prepare("SELECT * FROM `discounts` WHERE `code` = ? AND `status` = 'active'");
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $discount = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$discount) {
        return ['price' => $original_price, 'discount' => 0, 'code' => null, 'original_price' => $original_price, 'discount_id' => null];
    }
    
    // محاسبه تخفیف
    $discount_amount = 0;
    if($discount['type'] == 'fixed') {
        $discount_amount = min($discount['amount'], $original_price);
    } else {
        $discount_amount = ($original_price * $discount['amount']) / 100;
    }
    
    $final_price = max(0, $original_price - $discount_amount);
    
    // ثبت استفاده در جدول discount_usage
    $stmt = $connection->prepare("INSERT INTO `discount_usage` (`user_id`, `discount_id`, `plan_id`, `discount_amount`) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("iiii", $user_id, $discount['id'], $plan_id, $discount_amount);
    $stmt->execute();
    $stmt->close();
    
    // افزایش شمارنده استفاده
    $stmt = $connection->prepare("UPDATE `discounts` SET `used_count` = `used_count` + 1 WHERE `id` = ?");
    $stmt->bind_param("i", $discount['id']);
    $stmt->execute();
    $stmt->close();
    
    // پاک کردن temp
    $stmt = $connection->prepare("UPDATE `users` SET `temp` = NULL WHERE `userid` = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->close();
    
    return [
        'price' => $final_price,
        'discount' => $discount_amount,
        'code' => $code,
        'original_price' => $original_price,
        'discount_type' => $discount['type'],
        'discount_value' => $discount['amount'],
        'discount_id' => $discount['id']
    ];
}
?>
