<?php
echo "<html><head><meta charset='utf-8'></head><body style='font-family:tahoma;'>";
echo "<h1>🔍 تشخیص فایل مشکل‌دار</h1>";
echo "<p>هر فایل رو جداگانه تست می‌کنیم...</p>";
echo "<hr>";

error_reporting(E_ALL);
ini_set('display_errors', 1);

// تست هر فایل
$files = [
    'baseInfo.php' => 'اطلاعات پایه',
    'settings/values.php' => 'مقادیر و متن‌ها',
    'config.php' => 'تنظیمات اصلی',
    'server_manager.php' => 'مدیریت سرور',
    'service_creator.php' => 'سرویس ساز',
    'trading_plans_handler.php' => 'مدیریت Trading',
    'notification_system.php' => 'سیستم اعلان',
    'discount_system.php' => 'سیستم تخفیف',
    'advanced_reports.php' => 'گزارش پیشرفته'
];

$success = [];
$failed = [];

foreach($files as $file => $name) {
    echo "<div style='padding:10px;margin:10px 0;border:1px solid #ddd;border-radius:5px;'>";
    echo "<strong>$name</strong> ($file): ";
    
    if(!file_exists($file)) {
        echo "<span style='color:orange;'>⚠️ فایل وجود ندارد</span>";
        echo "</div>";
        continue;
    }
    
    ob_start();
    try {
        @include_once $file;
        ob_end_clean();
        echo "<span style='color:green;'>✅ موفق</span>";
        $success[] = $file;
    } catch (Throwable $e) {
        ob_end_clean();
        echo "<span style='color:red;'>❌ خطا</span>";
        echo "<div style='background:#ffcccc;padding:10px;margin-top:5px;border-radius:3px;'>";
        echo "<strong>پیام خطا:</strong> " . $e->getMessage() . "<br>";
        echo "<strong>فایل:</strong> " . $e->getFile() . "<br>";
        echo "<strong>خط:</strong> " . $e->getLine();
        echo "</div>";
        $failed[] = $file;
    }
    
    echo "</div>";
}

echo "<hr>";
echo "<h2>📊 نتیجه</h2>";
echo "<p><strong>موفق:</strong> " . count($success) . " فایل</p>";
echo "<p><strong>ناموفق:</strong> " . count($failed) . " فایل</p>";

if(empty($failed)) {
    echo "<div style='background:#d4edda;padding:15px;border-radius:5px;margin:10px 0;'>";
    echo "<h3>✅ همه فایل‌ها بدون مشکل هستند!</h3>";
    echo "<p>پس مشکل احتمالاً از:</p>";
    echo "<ul>";
    echo "<li>تابع check() که IP را بررسی می‌کند</li>";
    echo "<li>یا از متغیرهای undefined</li>";
    echo "</ul>";
    echo "<p><strong>راه حل:</strong></p>";
    echo "<p>1. Webhook را روی bot_wrapper.php تنظیم کنید</p>";
    echo "<p>2. یا فایل bot.php را با bot_safe.php جایگزین کنید</p>";
    echo "</div>";
} else {
    echo "<div style='background:#f8d7da;padding:15px;border-radius:5px;margin:10px 0;'>";
    echo "<h3>⚠️ فایل‌های مشکل‌دار:</h3>";
    echo "<ul>";
    foreach($failed as $f) {
        echo "<li><code>$f</code></li>";
    }
    echo "</ul>";
    echo "</div>";
}

echo "<hr>";
echo "<div style='text-align:center;padding:20px;'>";
echo "<a href='check_syntax.php' style='background:#007bff;color:white;padding:12px 24px;text-decoration:none;border-radius:5px;margin:5px;display:inline-block;'>بررسی Syntax</a>";
echo "<a href='full_debug.php' style='background:#28a745;color:white;padding:12px 24px;text-decoration:none;border-radius:5px;margin:5px;display:inline-block;'>تست کامل</a>";
echo "<a href='view_logs.php' style='background:#dc3545;color:white;padding:12px 24px;text-decoration:none;border-radius:5px;margin:5px;display:inline-block;'>مشاهده لاگ</a>";
echo "</div>";

echo "</body></html>";
?>
