-- حذف دسته‌بندی‌های تکراری
-- فقط یک نسخه از هر دسته نگه می‌داریم

-- دسته‌های تکراری برای حذف:
-- اگر "📅 پلن‌های یک ماهه 📅" و "📅 پلن‌های یک ماهه" هر دو وجود دارند، یکی را حذف می‌کنیم

-- ابتدا ببینیم چه دسته‌هایی داریم
SELECT id, name, emoji, status FROM plan_categories ORDER BY id;

-- حذف دسته‌بندی‌های تکراری (دقت کنید ID را بر اساس دیتابیس خودتان تنظیم کنید)
-- مثال: اگر ID دسته تکراری "📅 پلن‌های یک ماهه" برابر با 4 است:

-- DELETE FROM plan_categories WHERE id IN (4, 7, 10); -- ID های تکراری

-- یا به صورت امن‌تر، ابتدا پلن‌ها را به دسته صحیح منتقل کنید:
-- UPDATE service_plans SET category_id = 1 WHERE category_id = 4; -- از تکراری به اصلی
-- UPDATE service_plans SET category_id = 5 WHERE category_id = 7;
-- UPDATE service_plans SET category_id = 8 WHERE category_id = 10;

-- سپس دسته‌های خالی را حذف کنید:
-- DELETE FROM plan_categories WHERE id IN (4, 7, 10);

-- برای اطمینان، ابتدا این را اجرا کنید تا ببینید چه دسته‌هایی وجود دارد:
-- SELECT * FROM plan_categories;

-- دسته‌بندی‌های پیشنهادی (یکتا و مرتب):
-- 1. 📦 پلن استاندارد
-- 2. 📅 پلن‌های یک ماهه
-- 3. ⭐️ پلن پریمیوم
-- 4. 📆 پلن‌های سه ماهه
-- 5. 👑 پلن VIP
-- 6. 📊 پلن‌های شش ماهه

-- مثال برای یکتاسازی دسته‌ها:
/*
-- فرض کنیم:
-- ID 1 = 📦 پلن استاندارد (نگه می‌داریم)
-- ID 2 = 📅 پلن‌های یک ماهه 📅 (نگه می‌داریم)
-- ID 3 = ⭐️ پلن پریمیوم (نگه می‌داریم)
-- ID 4 = 📅 پلن‌های یک ماهه (تکراری - حذف می‌کنیم)
-- ID 5 = 📆 پلن‌های سه ماهه 📆 (نگه می‌داریم)
-- ID 6 = 👑 پلن VIP (نگه می‌داریم)
-- ID 7 = 📆 پلن‌های سه ماهه (تکراری - حذف می‌کنیم)
-- ID 8 = 📊 پلن‌های شش ماهه 📊 (نگه می‌داریم)
-- ID 9 = 📊 پلن‌های شش ماهه (تکراری - حذف می‌کنیم)

-- مرحله 1: انتقال پلن‌ها از دسته‌های تکراری به دسته‌های اصلی
UPDATE service_plans SET category_id = 2 WHERE category_id = 4;
UPDATE service_plans SET category_id = 5 WHERE category_id = 7;
UPDATE service_plans SET category_id = 8 WHERE category_id = 9;

-- مرحله 2: حذف دسته‌های تکراری
DELETE FROM plan_categories WHERE id IN (4, 7, 9);

-- مرحله 3: تأیید
SELECT id, name, emoji, status FROM plan_categories ORDER BY id;
SELECT COUNT(*) as plan_count, category_id FROM service_plans GROUP BY category_id;
*/
