<?php
// تست اتصال به دیتابیس و تشخیص خطا
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<pre>";
echo "=== تست کامل ربات APN ===\n\n";

// 1. تست اطلاعات پایه
echo "📋 مرحله 1: بررسی فایل‌های پایه...\n";
if(file_exists('baseInfo.php')) {
    include_once 'baseInfo.php';
    echo "✅ baseInfo.php لود شد\n";
    echo "   توکن: " . substr($botToken, 0, 20) . "...\n";
    echo "   ادمین: " . $admin . "\n";
    echo "   دیتابیس: " . $dbName . "\n";
    echo "   آدرس: " . $botUrl . "\n\n";
} else {
    die("❌ فایل baseInfo.php یافت نشد!\n");
}

// 2. تست اتصال به دیتابیس
echo "🗄️ مرحله 2: بررسی اتصال به دیتابیس...\n";
$connection = @new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
if($connection->connect_error){
    echo "❌ خطا در اتصال به دیتابیس:\n";
    echo "   " . $connection->connect_error . "\n";
    echo "\n💡 راه حل:\n";
    echo "   1. یوزرنیم و پسورد را در cPanel چک کنید\n";
    echo "   2. مطمئن شوید دیتابیس ساخته شده است\n";
    echo "   3. کاربر به دیتابیس اضافه شده است\n\n";
} else {
    echo "✅ اتصال به دیتابیس موفق\n";
    $connection->set_charset("utf8mb4");
    
    // 3. چک کردن جداول
    echo "\n📊 مرحله 3: بررسی جداول...\n";
    $tables = ['users', 'server_plans', 'orders_list', 'setting', 'server_info', 'server_config'];
    $missing_tables = [];
    foreach($tables as $table) {
        $result = @$connection->query("SELECT COUNT(*) as count FROM `$table`");
        if($result) {
            $row = $result->fetch_assoc();
            echo "✅ جدول $table: " . $row['count'] . " رکورد\n";
        } else {
            echo "❌ جدول $table وجود ندارد!\n";
            $missing_tables[] = $table;
        }
    }
    
    if(count($missing_tables) > 0) {
        echo "\n⚠️ جداول زیر وجود ندارند:\n";
        foreach($missing_tables as $t) echo "   - $t\n";
        echo "\n💡 راه حل: به آدرس زیر بروید:\n";
        echo "   " . $botUrl . "createDB.php\n\n";
    }
}

echo "\n";

// 4. تست API تلگرام
echo "🤖 مرحله 4: بررسی اتصال به تلگرام...\n";
$url = "https://api.telegram.org/bot" . $botToken . "/getMe";
$response = @file_get_contents($url);
if($response) {
    $data = json_decode($response, true);
    if($data['ok']) {
        echo "✅ اتصال به API تلگرام موفق\n";
        echo "   نام ربات: @" . $data['result']['username'] . "\n";
        echo "   نام: " . $data['result']['first_name'] . "\n";
    } else {
        echo "❌ خطا در API تلگرام\n";
        echo "   توکن ربات اشتباه است!\n";
    }
} else {
    echo "❌ نمی‌توان به API تلگرام متصل شد\n";
    echo "   allow_url_fopen غیرفعال است\n";
}

echo "\n";

// 5. تست Webhook
echo "🔗 مرحله 5: بررسی Webhook...\n";
$url = "https://api.telegram.org/bot" . $botToken . "/getWebhookInfo";
$response = @file_get_contents($url);
if($response) {
    $data = json_decode($response, true);
    if($data['ok']) {
        $webhook_url = $data['result']['url'] ?? 'تنظیم نشده';
        $pending = $data['result']['pending_update_count'] ?? 0;
        
        echo "URL: " . $webhook_url . "\n";
        echo "Pending Updates: " . $pending . "\n";
        
        if($pending > 0) {
            echo "⚠️ " . $pending . " پیام در صف است!\n";
        }
        
        if(isset($data['result']['last_error_message'])) {
            echo "\n❌ آخرین خطا:\n";
            echo "   " . $data['result']['last_error_message'] . "\n";
            echo "   تاریخ: " . date('Y-m-d H:i:s', $data['result']['last_error_date']) . "\n";
            
            if(strpos($data['result']['last_error_message'], '500') !== false) {
                echo "\n💡 خطای 500 یعنی:\n";
                echo "   - یک خطای PHP در bot.php وجود دارد\n";
                echo "   - یا یکی از فایل‌های include شده مشکل دارد\n";
            }
        } else {
            echo "✅ هیچ خطایی وجود ندارد\n";
        }
    }
}

echo "\n";

// 6. تست فایل‌های مورد نیاز
echo "📁 مرحله 6: بررسی فایل‌های ضروری...\n";
$required_files = [
    'bot.php',
    'config.php',
    'baseInfo.php',
    'settings/values.php',
    'settings/jdf.php'
];

foreach($required_files as $file) {
    if(file_exists($file)) {
        echo "✅ $file موجود است\n";
    } else {
        echo "❌ $file یافت نشد!\n";
    }
}

echo "\n";

// 7. تست خطاهای bot.php
echo "🔍 مرحله 7: بررسی خطاهای bot.php...\n";
echo "در حال بررسی...\n";

// تلاش برای include کردن bot.php
ob_start();
@include_once 'bot.php';
$output = ob_get_clean();

if(!empty($output)) {
    echo "⚠️ خروجی از bot.php:\n";
    echo $output . "\n";
}

echo "\n=== پایان تست ===\n\n";

echo "📌 خلاصه:\n";
if($connection && $connection->ping()) {
    echo "✅ دیتابیس: متصل\n";
} else {
    echo "❌ دیتابیس: قطع\n";
}

if($response && $data['ok']) {
    echo "✅ تلگرام: متصل\n";
} else {
    echo "❌ تلگرام: قطع\n";
}

echo "\n💡 مرحله بعدی:\n";
echo "1. خطاها را برطرف کنید\n";
echo "2. Webhook را پاک و دوباره تنظیم کنید:\n";
echo "   پاک کردن: " . $botUrl . "deleteWebhook.php\n";
echo "   تنظیم: " . $botUrl . "setWebhook.php\n";

echo "</pre>";
?>
