<?php
/**
 * تست اتصال به API روی سرور
 */

require_once 'config.php';

echo "<!DOCTYPE html>
<html dir='rtl' lang='fa'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>🧪 تست اتصال API</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Tahoma, Arial; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 20px; }
        .container { max-width: 900px; margin: 0 auto; background: white; border-radius: 20px; padding: 30px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
        h1 { color: #667eea; margin-bottom: 10px; }
        .box { background: #f8f9ff; border-radius: 15px; padding: 20px; margin: 20px 0; border-right: 5px solid #667eea; }
        .success { background: #d4edda; border-right-color: #28a745; color: #155724; }
        .error { background: #f8d7da; border-right-color: #dc3545; color: #721c24; }
        .info { background: #e7f3ff; border-right-color: #2196F3; color: #0d47a1; }
        .code { background: #2d2d2d; color: #f8f8f2; padding: 15px; border-radius: 10px; font-family: 'Courier New', monospace; margin: 10px 0; overflow-x: auto; white-space: pre-wrap; word-wrap: break-word; }
        .btn { display: inline-block; background: #667eea; color: white; padding: 12px 25px; border-radius: 8px; text-decoration: none; margin: 10px 5px; }
        .btn:hover { background: #5568d3; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #ddd; }
        th { background: #667eea; color: white; }
    </style>
</head>
<body>
<div class='container'>";

echo "<h1>🧪 تست اتصال به API سرور</h1>";
echo "<p style='color: #666; margin-bottom: 30px;'>بررسی اتصال ربات به API روی سرور VPS</p>";

// دریافت اطلاعات سرور
$stmt = $connection->query("SELECT * FROM servers WHERE status='active' LIMIT 1");
$server = $stmt->fetch_assoc();

if(!$server){
    echo "<div class='box error'>";
    echo "<h3>❌ سرور فعالی یافت نشد!</h3>";
    echo "<p>لطفاً ابتدا یک سرور در دیتابیس ثبت کنید.</p>";
    echo "</div>";
    echo "</div></body></html>";
    exit;
}

echo "<div class='box info'>";
echo "<h3>📡 اطلاعات سرور</h3>";
echo "<table>";
echo "<tr><th>فیلد</th><th>مقدار</th></tr>";
echo "<tr><td>نام سرور</td><td>{$server['name']}</td></tr>";
echo "<tr><td>آی پی</td><td>{$server['server_ip']}</td></tr>";
echo "<tr><td>وضعیت</td><td>" . ($server['status'] == 'active' ? '✅ فعال' : '❌ غیرفعال') . "</td></tr>";
echo "</table>";
echo "</div>";

// آدرس API
$api_url = 'http://' . $server['server_ip'] . '/api/create_vip_account.php';
$api_key = 'apn_vip_2024_secure_key_xyz123';

echo "<div class='box'>";
echo "<h3>🔗 اطلاعات API</h3>";
echo "<div class='code'>URL: {$api_url}
API Key: " . substr($api_key, 0, 20) . "...</div>";
echo "</div>";

// تست 1: تست اتصال ساده
echo "<div class='box'>";
echo "<h3>🧪 تست 1: بررسی دسترسی به API</h3>";

$test_data = [
    'action' => 'test_connection',
    'user_id' => 123456
];

$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($test_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-API-Key: ' . $api_key
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

echo "<p><strong>کد HTTP:</strong> {$http_code}</p>";

if($curl_error){
    echo "<div class='error' style='margin-top: 15px; padding: 15px;'>";
    echo "<h4>❌ خطای cURL</h4>";
    echo "<p>{$curl_error}</p>";
    echo "<h4>💡 راه‌های حل:</h4>";
    echo "<ul style='padding-right: 25px; margin-top: 10px; line-height: 2;'>";
    echo "<li>مطمئن شوید فایل <code>vps_api_create_account.php</code> روی سرور در مسیر <code>/var/www/api/</code> قرار دارد</li>";
    echo "<li>چک کنید که Nginx یا Apache درست تنظیم شده باشد</li>";
    echo "<li>فایروال سرور را بررسی کنید</li>";
    echo "</ul>";
    echo "</div>";
} elseif($http_code != 200){
    echo "<div class='error' style='margin-top: 15px; padding: 15px;'>";
    echo "<h4>❌ خطای HTTP {$http_code}</h4>";
    echo "<p>سرور پاسخ غیرمعمول برگرداند.</p>";
    
    if($http_code == 404){
        echo "<h4>💡 مشکل: فایل API پیدا نشد</h4>";
        echo "<p>فایل <code>vps_api_create_account.php</code> را در مسیر صحیح روی سرور قرار دهید:</p>";
        echo "<div class='code'>/var/www/api/create_vip_account.php</div>";
    } elseif($http_code == 403){
        echo "<h4>💡 مشکل: API Key نادرست</h4>";
        echo "<p>API Key در فایل API و این تست باید یکسان باشد.</p>";
    } elseif($http_code == 500){
        echo "<h4>💡 مشکل: خطای داخلی سرور</h4>";
        echo "<p>لاگ‌های PHP روی سرور را بررسی کنید.</p>";
    }
    
    echo "<h4>پاسخ خام:</h4>";
    echo "<div class='code'>" . htmlspecialchars(substr($response, 0, 500)) . "</div>";
    echo "</div>";
} else {
    $result = json_decode($response, true);
    
    if($result && isset($result['success'])){
        if($result['success']){
            echo "<div class='success' style='margin-top: 15px; padding: 15px;'>";
            echo "<h4>✅ اتصال موفق!</h4>";
            echo "<p>ربات با موفقیت به API سرور متصل شد.</p>";
            echo "<div class='code'>" . json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</div>";
            echo "</div>";
        } else {
            echo "<div class='error' style='margin-top: 15px; padding: 15px;'>";
            echo "<h4>❌ خطا از API</h4>";
            echo "<p>API پاسخ داد اما عملیات ناموفق بود:</p>";
            echo "<div class='code'>" . json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</div>";
            echo "</div>";
        }
    } else {
        echo "<div class='error' style='margin-top: 15px; padding: 15px;'>";
        echo "<h4>⚠️ پاسخ نامعتبر</h4>";
        echo "<p>پاسخ دریافت شده JSON معتبر نیست:</p>";
        echo "<div class='code'>" . htmlspecialchars($response) . "</div>";
        echo "</div>";
    }
}

echo "</div>";

// تست 2: تست ساخت اکانت آزمایشی (فقط اگه تست 1 موفق بود)
if(!$curl_error && $http_code == 200 && isset($result['success']) && $result['success']){
    echo "<div class='box'>";
    echo "<h3>🧪 تست 2: ساخت اکانت آزمایشی (اختیاری)</h3>";
    echo "<p>برای تست کامل، می‌توانید یک اکانت آزمایشی بسازید:</p>";
    
    if(!isset($_GET['create_test'])){
        echo "<a href='?create_test=1' class='btn'>🚀 ساخت اکانت تستی</a>";
    } else {
        echo "<p><em>در حال ساخت اکانت تستی...</em></p>";
        
        $create_data = [
            'action' => 'create_account',
            'user_id' => 999999,
            'plan_id' => 'test_plan',
            'volume_gb' => 10,
            'days' => 7,
            'limit_ip' => 2
        ];
        
        $ch = curl_init($api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($create_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'X-API-Key: ' . $api_key
        ]);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response2 = curl_exec($ch);
        $http_code2 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if($http_code2 == 200){
            $result2 = json_decode($response2, true);
            
            if($result2 && $result2['success']){
                echo "<div class='success' style='margin-top: 15px; padding: 15px;'>";
                echo "<h4>🎉 اکانت تستی با موفقیت ساخته شد!</h4>";
                echo "<table style='background: white; margin-top: 15px;'>";
                echo "<tr><th>فیلد</th><th>مقدار</th></tr>";
                echo "<tr><td>Email</td><td>{$result2['data']['email']}</td></tr>";
                echo "<tr><td>UUID</td><td>" . substr($result2['data']['uuid'], 0, 20) . "...</td></tr>";
                echo "<tr><td>Inbound ID</td><td>{$result2['data']['inbound_id']}</td></tr>";
                echo "<tr><td>حجم</td><td>{$result2['data']['volume_gb']} GB</td></tr>";
                echo "<tr><td>مدت</td><td>{$result2['data']['days']} روز</td></tr>";
                echo "<tr><td>تاریخ انقضا</td><td>{$result2['data']['expire_date']}</td></tr>";
                echo "</table>";
                
                if(isset($result2['data']['vless_link'])){
                    echo "<h4 style='margin-top: 20px;'>🔗 لینک VLESS:</h4>";
                    echo "<div class='code' style='direction: ltr; text-align: left; font-size: 12px;'>" . $result2['data']['vless_link'] . "</div>";
                }
                
                echo "</div>";
            } else {
                echo "<div class='error' style='margin-top: 15px; padding: 15px;'>";
                echo "<h4>❌ خطا در ساخت اکانت</h4>";
                echo "<div class='code'>" . json_encode($result2, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</div>";
                echo "</div>";
            }
        } else {
            echo "<div class='error' style='margin-top: 15px; padding: 15px;'>";
            echo "<h4>❌ خطای HTTP {$http_code2}</h4>";
            echo "<div class='code'>" . htmlspecialchars($response2) . "</div>";
            echo "</div>";
        }
    }
    
    echo "</div>";
}

// نتیجه نهایی
echo "<div class='box' style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;'>";
echo "<h3 style='color: white;'>📊 نتیجه نهایی</h3>";

if(!$curl_error && $http_code == 200 && isset($result['success']) && $result['success']){
    echo "<p style='font-size: 18px; line-height: 1.8;'>";
    echo "✅ <strong>سیستم آماده است!</strong><br>";
    echo "ربات می‌تواند با موفقیت به API سرور متصل شود و سرویس بسازد.<br><br>";
    echo "مرحله بعد: تست کامل از طریق ربات تلگرام";
    echo "</p>";
} else {
    echo "<p style='font-size: 18px; line-height: 1.8; color: #fff3cd;'>";
    echo "⚠️ <strong>نیاز به بررسی</strong><br>";
    echo "لطفاً موارد بالا را بررسی کنید و مشکلات را رفع نمایید.";
    echo "</p>";
}

echo "</div>";

echo "<div style='text-align: center; margin-top: 30px;'>";
echo "<a href='COMPLETE_SETUP_CHECKLIST.html' class='btn'>📋 بازگشت به چک لیست</a>";
echo "<a href='?refresh=1' class='btn'>🔄 تست مجدد</a>";
echo "</div>";

echo "</div></body></html>";
?>
