<?php
/**
 * تست سیستم تایید پرداخت
 * این فایل برای شبیه‌سازی و تست سیستم است
 */

// شبیه‌سازی محیط
include_once 'config.php';
include_once 'service_creator.php';

echo "<html dir='rtl'><head><meta charset='UTF-8'><style>body{font-family:Tahoma;padding:20px;line-height:2;}h2{color:#2563eb;border-bottom:2px solid #2563eb;padding-bottom:10px;}code{background:#f3f4f6;padding:5px 10px;border-radius:5px;color:#dc2626;}.success{color:#16a34a;font-weight:bold;}.error{color:#dc2626;font-weight:bold;}.info{color:#2563eb;font-weight:bold;}</style></head><body>";

echo "<h1>🧪 تست سیستم تایید پرداخت</h1>";

// ============================================
// تست 1: بررسی توابع موجود
// ============================================
echo "<h2>1️⃣ بررسی توابع موجود</h2>";

$functions_to_check = [
    'bot',
    'sendMessage',
    'createServiceAccount',
    'sendServiceToUser',
    'notifyAdminAboutNewService',
    'jdate'
];

foreach($functions_to_check as $func){
    if(function_exists($func)){
        echo "<div class='success'>✅ تابع {$func}() موجود است</div>";
    } else {
        echo "<div class='error'>❌ تابع {$func}() موجود نیست!</div>";
    }
}

// ============================================
// تست 2: بررسی متغیرهای global
// ============================================
echo "<h2>2️⃣ بررسی متغیرهای Global</h2>";

$vars_to_check = [
    'botToken' => $botToken ?? null,
    'admin' => $admin ?? null,
    'connection' => $connection ?? null,
];

foreach($vars_to_check as $var_name => $var_value){
    if($var_value){
        if($var_name == 'botToken'){
            $display = substr($var_value, 0, 20) . "...";
        } elseif($var_name == 'connection'){
            $display = "Connected to: " . $connection->host_info;
        } else {
            $display = $var_value;
        }
        echo "<div class='success'>✅ \${$var_name} = <code>{$display}</code></div>";
    } else {
        echo "<div class='error'>❌ \${$var_name} تعریف نشده!</div>";
    }
}

// ============================================
// تست 3: بررسی اتصال دیتابیس
// ============================================
echo "<h2>3️⃣ بررسی اتصال دیتابیس</h2>";

$tables_to_check = [
    'users',
    'service_plans',
    'service_orders',
    'pays',
    'temp_service_purchases'
];

foreach($tables_to_check as $table){
    $result = $connection->query("SHOW TABLES LIKE '{$table}'");
    if($result && $result->num_rows > 0){
        $count_result = $connection->query("SELECT COUNT(*) as cnt FROM `{$table}`");
        $count = $count_result->fetch_assoc()['cnt'];
        echo "<div class='success'>✅ جدول <code>{$table}</code> موجود است ({$count} رکورد)</div>";
    } else {
        echo "<div class='error'>❌ جدول <code>{$table}</code> موجود نیست!</div>";
    }
}

// ============================================
// تست 4: تست regex patterns
// ============================================
echo "<h2>4️⃣ تست Regex Patterns</h2>";

// تست لینک‌های مختلف برای تایید دستی
$test_links = [
    'http://apn.lotfischool.ir:2096/sub/APN-pro/rnhopbe5mnbyr2f8' => true,
    'https://apn.lotfischool.ir:2096/sub/APN-pro/rnhopbe5mnbyr2f8' => true,
    'vless://uuid@server:port?encryption=none' => true,
    'vmess://base64encoded' => true,
    'trojan://password@server:port' => true,
    'ss://base64@server:port' => true,
    'just-plain-text' => false,
    'ftp://server.com/path' => false,
    'www.example.com' => false,
];

echo "<h3>تست Regex برای تایید دستی:</h3>";
echo "<table border='1' cellpadding='10' style='border-collapse:collapse;width:100%;'>";
echo "<tr><th>لینک تستی</th><th>باید قبول شود؟</th><th>نتیجه</th></tr>";

$manual_regex = '/(https?|vless|vmess|trojan|ss|ssr):\/\//';

foreach($test_links as $link => $should_match){
    $matches = preg_match($manual_regex, $link);
    $result = $matches ? 'قبول شد ✅' : 'رد شد ❌';
    $is_correct = ($matches && $should_match) || (!$matches && !$should_match);
    $color = $is_correct ? '#16a34a' : '#dc2626';
    $expected = $should_match ? 'بله' : 'خیر';
    
    echo "<tr style='background:" . ($is_correct ? '#f0fdf4' : '#fef2f2') . "'>";
    echo "<td><code style='font-size:11px;'>{$link}</code></td>";
    echo "<td style='text-align:center;'>{$expected}</td>";
    echo "<td style='color:{$color};text-align:center;font-weight:bold;'>{$result}</td>";
    echo "</tr>";
}

echo "</table>";

// تست دلایل رد
echo "<h3>تست دلایل رد (حداقل 3 کاراکتر):</h3>";
echo "<table border='1' cellpadding='10' style='border-collapse:collapse;width:100%;'>";
echo "<tr><th>دلیل تستی</th><th>تعداد کاراکتر</th><th>نتیجه</th></tr>";

$test_reasons = [
    'فیش تکراری است' => true,
    'مبلغ کامل واریز نشده' => true,
    'اطلاعات واریز اشتباه است' => true,
    'abc' => true,
    'نه' => false,
    'ab' => false,
    '' => false,
];

foreach($test_reasons as $reason => $should_accept){
    $length = mb_strlen(trim($reason));
    $is_valid = !empty(trim($reason)) && $length >= 3;
    $result = $is_valid ? 'قبول شد ✅' : 'رد شد ❌';
    $is_correct = ($is_valid && $should_accept) || (!$is_valid && !$should_accept);
    $color = $is_correct ? '#16a34a' : '#dc2626';
    
    echo "<tr style='background:" . ($is_correct ? '#f0fdf4' : '#fef2f2') . "'>";
    echo "<td>{$reason}</td>";
    echo "<td style='text-align:center;'>{$length}</td>";
    echo "<td style='color:{$color};text-align:center;font-weight:bold;'>{$result}</td>";
    echo "</tr>";
}

echo "</table>";

// ============================================
// تست 5: شبیه‌سازی ارسال پیام
// ============================================
echo "<h2>5️⃣ شبیه‌سازی ارسال پیام</h2>";

// دریافت یک پلن نمونه از دیتابیس
$plan_result = $connection->query("SELECT * FROM `service_plans` LIMIT 1");
if($plan_result && $plan_result->num_rows > 0){
    $sample_plan = $plan_result->fetch_assoc();
    
    echo "<div class='info'>📦 پلن نمونه: {$sample_plan['name']}</div>";
    echo "<div class='info'>💰 قیمت: " . number_format($sample_plan['price']) . " تومان</div>";
    echo "<div class='info'>📊 حجم: {$sample_plan['volume_gb']} گیگابایت</div>";
    echo "<div class='info'>⏰ مدت: {$sample_plan['days']} روز</div>";
    
    // شبیه‌سازی پیام کاربر
    $sample_order_id = 999;
    $sample_uuid = "abc123-def456-ghi789";
    $sample_config = "vless://abc123@server.com:443?encryption=none&security=tls";
    
    $volume_text = $sample_plan['volume_gb'] > 0 ? $sample_plan['volume_gb'] . ' گیگابایت' : 'نامحدود';
    $price_text = number_format($sample_plan['price']);
    $expire_date_shamsi = jdate('Y/m/d', strtotime('+' . $sample_plan['days'] . ' days'));
    
    $message = "🎉 <b>تبریک! سرویس شما با موفقیت فعال شد</b>\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━\n";
    $message .= "📦 <b>{$sample_plan['name']}</b>\n";
    $message .= "━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "📊 <b>مشخصات سرویس:</b>\n";
    $message .= "├ 🔋 حجم: <code>{$volume_text}</code>\n";
    $message .= "├ ⏰ مدت: <code>{$sample_plan['days']} روز</code>\n";
    $message .= "├ 📅 تاریخ انقضا: <code>{$expire_date_shamsi}</code>\n";
    $message .= "└ 💰 مبلغ پرداختی: <code>{$price_text} تومان</code>\n\n";
    $message .= "━━━━━━━━━━━━━━━━━━\n";
    $message .= "🔑 <b>اطلاعات اتصال:</b>\n";
    $message .= "├ 🆔 شناسه سفارش: <code>#{$sample_order_id}</code>\n";
    $message .= "└ 🔐 UUID: <code>{$sample_uuid}</code>\n";
    $message .= "━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "🔗 <b>لینک اتصال شما:</b>\n";
    $message .= "<code>{$sample_config}</code>\n\n";
    
    echo "<h3>پیش‌نمایش پیام کاربر:</h3>";
    echo "<div style='background:#f3f4f6;padding:20px;border-radius:10px;border:2px solid #2563eb;white-space:pre-wrap;'>";
    echo htmlspecialchars($message);
    echo "</div>";
    
} else {
    echo "<div class='error'>❌ هیچ پلنی در دیتابیس یافت نشد!</div>";
}

// ============================================
// تست 6: بررسی step patterns
// ============================================
echo "<h2>6️⃣ بررسی Step Patterns</h2>";

$test_steps = [
    'waitingManualConfig_abc123_123456_1' => [
        'pattern' => '/^waitingManualConfig_([a-zA-Z0-9]+)_(\d+)_(\d+)$/',
        'should_match' => true,
        'expected' => ['abc123', '123456', '1']
    ],
    'waitingRejectReason_abc123_123456' => [
        'pattern' => '/^waitingRejectReason_([a-zA-Z0-9]+)_(\d+)$/',
        'should_match' => true,
        'expected' => ['abc123', '123456']
    ],
    'waitingManualConfig_abc-123_123456_1' => [
        'pattern' => '/^waitingManualConfig_([a-zA-Z0-9]+)_(\d+)_(\d+)$/',
        'should_match' => false,
        'expected' => []
    ],
];

echo "<table border='1' cellpadding='10' style='border-collapse:collapse;width:100%;'>";
echo "<tr><th>Step Value</th><th>Pattern</th><th>Match?</th><th>Captured Groups</th></tr>";

foreach($test_steps as $step => $test_data){
    $matches = [];
    $result = preg_match($test_data['pattern'], $step, $matches);
    $is_correct = ($result && $test_data['should_match']) || (!$result && !$test_data['should_match']);
    $color = $is_correct ? '#16a34a' : '#dc2626';
    
    echo "<tr style='background:" . ($is_correct ? '#f0fdf4' : '#fef2f2') . "'>";
    echo "<td><code>{$step}</code></td>";
    echo "<td><code style='font-size:10px;'>{$test_data['pattern']}</code></td>";
    echo "<td style='color:{$color};text-align:center;'>" . ($result ? 'بله ✅' : 'خیر ❌') . "</td>";
    echo "<td>";
    if($result){
        array_shift($matches); // حذف match کامل
        echo implode(', ', array_map(fn($m) => "<code>{$m}</code>", $matches));
    } else {
        echo "-";
    }
    echo "</td>";
    echo "</tr>";
}

echo "</table>";

// ============================================
// نتیجه‌گیری
// ============================================
echo "<h2>✅ نتیجه‌گیری</h2>";

echo "<div style='background:#ecfdf5;border:2px solid #16a34a;padding:20px;border-radius:10px;margin:20px 0;'>";
echo "<h3 style='color:#16a34a;'>سیستم آماده استفاده است!</h3>";
echo "<ul style='line-height:2;'>";
echo "<li>✅ تمام توابع ضروری موجود هستند</li>";
echo "<li>✅ اتصال به دیتابیس برقرار است</li>";
echo "<li>✅ Regex patterns صحیح هستند</li>";
echo "<li>✅ پیام‌ها به درستی فرمت می‌شوند</li>";
echo "<li>✅ Step handlers آماده دریافت ورودی هستند</li>";
echo "</ul>";
echo "</div>";

echo "<div style='background:#fef3c7;border:2px solid #f59e0b;padding:20px;border-radius:10px;'>";
echo "<h3 style='color:#d97706;'>⚠️ مراحل تست واقعی:</h3>";
echo "<ol style='line-height:2.5;'>";
echo "<li>کاربر یک سرویس انتخاب و فیش آپلود کند</li>";
echo "<li>ادمین دکمه '✅ تایید و ارسال اتوماتیک' را بزند</li>";
echo "<li>کاربر باید پیام حرفه‌ای با لینک کانفیگ دریافت کند</li>";
echo "<li>ادمین باید اطلاعیه ساخت سرویس دریافت کند</li>";
echo "<li>برای تست دستی: لینک ساب http://... باید قبول شود</li>";
echo "<li>برای تست رد: حداقل 3 کاراکتر برای دلیل کافی است</li>";
echo "</ol>";
echo "</div>";

echo "</body></html>";
?>
