<?php
include "config.php";
include "service_creator.php";

echo "<html><head><meta charset='UTF-8'><style>
body{font-family:Tahoma; direction:rtl; text-align:right; padding:20px;}
.success{color:#4caf50; font-weight:bold;}
.error{color:#f44336; font-weight:bold;}
.info{color:#2196f3;}
.step{background:#e8f5e9; border:1px solid #4caf50; padding:15px; margin:10px 0;}
</style></head><body>";

if(!isset($_POST['hash_id'])){
    echo "<p class='error'>❌ hash_id ارسال نشده</p>";
    exit;
}

$hash_id = $_POST['hash_id'];

echo "<h1>✅ تست تایید پرداخت</h1>";
echo "<p class='info'>Hash ID: <code>{$hash_id}</code></p>";

// پیدا کردن پرداخت
$stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id` = ?");
$stmt->bind_param("s", $hash_id);
$stmt->execute();
$payment = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$payment){
    echo "<p class='error'>❌ پرداختی با این hash_id یافت نشد!</p>";
    exit;
}

echo "<div class='step'>";
echo "<h2>📋 اطلاعات پرداخت</h2>";
echo "<ul>";
echo "<li>کاربر: {$payment['user_id']}</li>";
echo "<li>مبلغ: " . number_format($payment['price']) . " تومان</li>";
echo "<li>وضعیت فعلی: {$payment['state']}</li>";
echo "</ul>";
echo "</div>";

// پیدا کردن plan_id
$stmt = $connection->prepare("SELECT * FROM `temp_service_purchases` WHERE `hash_id` = ?");
$stmt->bind_param("s", $hash_id);
$stmt->execute();
$temp = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$temp){
    echo "<p class='error'>❌ اطلاعات موقت یافت نشد!</p>";
    exit;
}

$plan_id = $temp['plan_id'];
$user_id = $payment['user_id'];

echo "<div class='step'>";
echo "<h2>📦 اطلاعات پلن</h2>";
echo "<p>Plan ID: {$plan_id}</p>";
echo "</div>";

// پیدا کردن اطلاعات پلن
$stmt = $connection->prepare("SELECT * FROM `service_plans` WHERE `id` = ?");
$stmt->bind_param("i", $plan_id);
$stmt->execute();
$plan = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$plan){
    echo "<p class='error'>❌ پلن یافت نشد!</p>";
    exit;
}

echo "<div class='step'>";
echo "<h2>✅ تایید پرداخت و ساخت سرویس</h2>";

// به‌روزرسانی وضعیت پرداخت
$stmt = $connection->prepare("UPDATE `pays` SET `state` = 'approved' WHERE `hash_id` = ?");
$stmt->bind_param("s", $hash_id);
$update_result = $stmt->execute();
$stmt->close();

if($update_result){
    echo "<p class='success'>✅ وضعیت پرداخت به approved تغییر کرد</p>";
} else {
    echo "<p class='error'>❌ خطا در به‌روزرسانی: " . $connection->error . "</p>";
}

// ساخت سرویس
echo "<h3>🔧 ساخت سرویس...</h3>";

$service_result = createServiceAccount($user_id, $plan_id, $hash_id);

if($service_result['success']){
    echo "<p class='success'>✅ سرویس با موفقیت ساخته شد!</p>";
    echo "<ul>";
    echo "<li>Config: موجود ✅</li>";
    echo "<li>آدرس کانفیگ: موجود ✅</li>";
    echo "</ul>";
    
    // حذف از temp
    $connection->query("DELETE FROM temp_service_purchases WHERE hash_id='{$hash_id}'");
    echo "<p class='info'>🗑️ رکورد موقت حذف شد</p>";
    
    echo "<p class='success'>🎉 فرآیند کامل شد!</p>";
} else {
    echo "<p class='error'>❌ خطا در ساخت سرویس: " . $service_result['message'] . "</p>";
}

echo "</div>";

echo "<hr>";
echo "<p><a href='test_full_flow.php'>← بازگشت به تست اصلی</a></p>";
echo "<p><a href='debug_live.php'>📊 مشاهده debug_live</a></p>";

echo "</body></html>";
?>
