<?php
/**
 * اسکریپت تست جریان خرید
 * این فایل رو از مرورگر اجرا کنید تا ببینید مشکل کجاست
 */

include_once 'config.php';

echo "<h1>🔍 تست جریان خرید سرویس</h1>";
echo "<hr>";

// تست 1: بررسی جدول دسته‌بندی‌ها
echo "<h2>1️⃣ بررسی جدول plan_categories</h2>";
$stmt = $connection->prepare("SELECT * FROM `plan_categories` WHERE `status`='active'");
$stmt->execute();
$categories = $stmt->get_result();
$stmt->close();

if($categories->num_rows == 0){
    echo "<p style='color:red;'>❌ هیچ دسته‌بندی فعالی وجود ندارد!</p>";
    echo "<p><strong>راه حل:</strong> باید دسته‌بندی اضافه کنید.</p>";
} else {
    echo "<p style='color:green;'>✅ تعداد دسته‌بندی‌های فعال: <strong>{$categories->num_rows}</strong></p>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>نام</th><th>ایموجی</th><th>وضعیت</th><th>ترتیب</th></tr>";
    while($cat = $categories->fetch_assoc()){
        echo "<tr>";
        echo "<td>{$cat['id']}</td>";
        echo "<td>{$cat['name']}</td>";
        echo "<td>{$cat['emoji']}</td>";
        echo "<td>{$cat['status']}</td>";
        echo "<td>{$cat['sort_order']}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<hr>";

// تست 2: بررسی جدول سرورها
echo "<h2>2️⃣ بررسی جدول servers</h2>";
$stmt = $connection->prepare("SELECT * FROM `servers` WHERE `status`='active'");
$stmt->execute();
$servers = $stmt->get_result();
$stmt->close();

if($servers->num_rows == 0){
    echo "<p style='color:red;'>❌ هیچ سروری فعال نیست!</p>";
    echo "<p><strong>راه حل:</strong> باید سرور اضافه کنید.</p>";
} else {
    echo "<p style='color:green;'>✅ تعداد سرورهای فعال: <strong>{$servers->num_rows}</strong></p>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>نام</th><th>لوکیشن</th><th>IP</th><th>وضعیت</th></tr>";
    while($server = $servers->fetch_assoc()){
        echo "<tr>";
        echo "<td>{$server['id']}</td>";
        echo "<td>{$server['name']}</td>";
        echo "<td>{$server['location']}</td>";
        echo "<td>{$server['server_ip']}</td>";
        echo "<td>{$server['status']}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<hr>";

// تست 3: بررسی جدول تعرفه‌ها
echo "<h2>3️⃣ بررسی جدول service_plans</h2>";
$stmt = $connection->prepare("SELECT sp.*, pc.name as category_name, s.name as server_name 
                               FROM `service_plans` sp 
                               LEFT JOIN `plan_categories` pc ON sp.category_id = pc.id 
                               LEFT JOIN `servers` s ON sp.server_id = s.id 
                               WHERE sp.status='active'");
$stmt->execute();
$plans = $stmt->get_result();
$stmt->close();

if($plans->num_rows == 0){
    echo "<p style='color:red;'>❌ هیچ تعرفه فعالی وجود ندارد!</p>";
    echo "<p><strong>راه حل:</strong> باید تعرفه اضافه کنید.</p>";
} else {
    echo "<p style='color:green;'>✅ تعداد تعرفه‌های فعال: <strong>{$plans->num_rows}</strong></p>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>نام</th><th>دسته</th><th>سرور</th><th>حجم</th><th>مدت</th><th>قیمت</th><th>وضعیت</th></tr>";
    while($plan = $plans->fetch_assoc()){
        $volume = $plan['volume_gb'] > 0 ? $plan['volume_gb'] . ' GB' : 'نامحدود';
        echo "<tr>";
        echo "<td>{$plan['id']}</td>";
        echo "<td>{$plan['name']}</td>";
        echo "<td>{$plan['category_name']}</td>";
        echo "<td>{$plan['server_name']}</td>";
        echo "<td>{$volume}</td>";
        echo "<td>{$plan['days']} روز</td>";
        echo "<td>" . number_format($plan['price']) . " تومان</td>";
        echo "<td>{$plan['status']}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<hr>";

// تست 4: بررسی ساختار جداول
echo "<h2>4️⃣ بررسی ساختار جداول</h2>";

$tables_to_check = [
    'plan_categories' => ['id', 'name', 'emoji', 'status', 'sort_order'],
    'servers' => ['id', 'name', 'location', 'server_ip', 'status'],
    'service_plans' => ['id', 'name', 'category_id', 'server_id', 'volume_gb', 'days', 'price', 'status'],
    'temp_service_purchases' => ['id', 'hash_id', 'user_id', 'plan_id'],
    'service_orders' => ['id', 'user_id', 'plan_id', 'server_id', 'hash_id', 'email', 'uuid', 'config_link', 'status']
];

foreach($tables_to_check as $table => $required_columns){
    $result = $connection->query("SHOW COLUMNS FROM `$table`");
    if($result){
        $existing_columns = [];
        while($row = $result->fetch_assoc()){
            $existing_columns[] = $row['Field'];
        }
        
        $missing = array_diff($required_columns, $existing_columns);
        
        if(empty($missing)){
            echo "<p style='color:green;'>✅ جدول <strong>$table</strong> کامل است</p>";
        } else {
            echo "<p style='color:orange;'>⚠️ جدول <strong>$table</strong> ستون‌های زیر را ندارد: <strong>" . implode(', ', $missing) . "</strong></p>";
        }
    } else {
        echo "<p style='color:red;'>❌ جدول <strong>$table</strong> وجود ندارد!</p>";
    }
}

echo "<hr>";

// نتیجه‌گیری
echo "<h2>📊 نتیجه‌گیری</h2>";

$has_categories = $categories->num_rows > 0;
$has_servers = $servers->num_rows > 0;
$has_plans = $plans->num_rows > 0;

if($has_categories && $has_servers && $has_plans){
    echo "<p style='color:green; font-size:20px;'>✅ همه چیز آماده است! جریان خرید باید کار کند.</p>";
    echo "<p>اگه هنوز کار نمی‌کنه، لطفا webhook رو دوباره ست کنید:</p>";
    echo "<p><a href='setWebhook.php' target='_blank'>setWebhook.php</a></p>";
} else {
    echo "<p style='color:red; font-size:20px;'>❌ سیستم ناقص است!</p>";
    echo "<ul>";
    if(!$has_categories) echo "<li>دسته‌بندی اضافه کنید</li>";
    if(!$has_servers) echo "<li>سرور اضافه کنید</li>";
    if(!$has_plans) echo "<li>تعرفه اضافه کنید</li>";
    echo "</ul>";
    echo "<p><strong>برای اضافه کردن داده‌های نمونه، فایل <code>add_sample_data.php</code> رو اجرا کنید.</strong></p>";
}

echo "<hr>";
echo "<p style='text-align:center; color:#666;'>تاریخ: " . date('Y-m-d H:i:s') . "</p>";
?>
