<?php
include "config.php";

echo "<html><head><meta charset='UTF-8'><style>
body{font-family:Tahoma; direction:rtl; text-align:right; padding:20px;}
.step{background:#e8f5e9; border-right:4px solid #4caf50; padding:15px; margin:10px 0;}
.success{color:#4caf50; font-weight:bold;}
.error{color:#f44336; font-weight:bold;}
.info{color:#2196f3;}
button{padding:10px 20px; margin:5px; background:#2196f3; color:white; border:none; cursor:pointer; border-radius:4px;}
button:hover{background:#1976d2;}
</style></head><body>";

echo "<h1>🧪 تست کامل فلوی خرید سرویس</h1>";

// مرحله 1: چک کردن پلن‌ها
echo "<div class='step'>";
echo "<h2>1️⃣ بررسی پلن‌های موجود</h2>";
$plans = $connection->query("SELECT * FROM service_plans WHERE status='active' LIMIT 1");
if($plans && $plans->num_rows > 0){
    $plan = $plans->fetch_assoc();
    echo "<p class='success'>✅ پلن تست پیدا شد: {$plan['name']} - قیمت: " . number_format($plan['price']) . " تومان</p>";
    echo "<p>ID: {$plan['id']}</p>";
    $plan_id = $plan['id'];
} else {
    echo "<p class='error'>❌ پلنی موجود نیست!</p>";
    echo "<p>لطفا ابتدا از add_sample_data.php استفاده کنید</p>";
    exit;
}
echo "</div>";

// مرحله 2: شبیه‌سازی کلیک روی "پرداخت فیش بانکی"
echo "<div class='step'>";
echo "<h2>2️⃣ شبیه‌سازی انتخاب پرداخت فیش</h2>";

// تست با کاربر ادمین
$test_user_id = 8110165534;
echo "<p class='info'>🔧 کاربر تست: {$test_user_id}</p>";

// بررسی وجود کاربر
$user_check = $connection->query("SELECT * FROM users WHERE userid={$test_user_id}");
if(!$user_check || $user_check->num_rows == 0){
    echo "<p class='error'>❌ کاربر در دیتابیس نیست! ساخت کاربر...</p>";
    $connection->query("INSERT INTO users (userid, name, username) VALUES ({$test_user_id}, 'تست کاربر', 'test_user')");
}

// تنظیم step
$new_step = "uploadReceiptForPlan_{$plan_id}";
$update = $connection->query("UPDATE users SET step='{$new_step}' WHERE userid={$test_user_id}");

if($update){
    echo "<p class='success'>✅ Step تنظیم شد: <code>{$new_step}</code></p>";
    
    // چک کردن
    $verify = $connection->query("SELECT step FROM users WHERE userid={$test_user_id}");
    $user_data = $verify->fetch_assoc();
    echo "<p class='info'>📋 Step ذخیره شده: <code>{$user_data['step']}</code></p>";
} else {
    echo "<p class='error'>❌ خطا در تنظیم step: " . $connection->error . "</p>";
}

echo "</div>";

// مرحله 3: شبیه‌سازی ارسال فیش
echo "<div class='step'>";
echo "<h2>3️⃣ شبیه‌سازی ارسال فیش</h2>";

// استفاده از یک file_id تست
$test_photo = "AgACAgQAAxkBAAIBvGZHZ8x9jKLtest_file_id"; // فایل تست

echo "<p class='info'>📷 Photo ID تست: <code>{$test_photo}</code></p>";

// ثبت فیش مانند کد اصلی
function RandomString2($length = 9) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}

$hash_id = RandomString2();
$stmt = $connection->prepare("INSERT INTO `pays` (`user_id`, `hash_id`, `type`, `price`, `state`, `photo`) 
                               VALUES (?, ?, 'SERVICE_PLAN', ?, 'pending', ?)");
$stmt->bind_param("isis", $test_user_id, $hash_id, $plan['price'], $test_photo);
$insert_result = $stmt->execute();
$stmt->close();

if($insert_result){
    echo "<p class='success'>✅ فیش در جدول pays ثبت شد</p>";
    echo "<p class='info'>🆔 Hash ID: <code>{$hash_id}</code></p>";
    
    // ثبت در temp_service_purchases
    $stmt2 = $connection->prepare("INSERT INTO `temp_service_purchases` (`hash_id`, `user_id`, `plan_id`) VALUES (?, ?, ?)");
    $stmt2->bind_param("sii", $hash_id, $test_user_id, $plan_id);
    $temp_result = $stmt2->execute();
    $stmt2->close();
    
    if($temp_result){
        echo "<p class='success'>✅ رکورد در temp_service_purchases ثبت شد</p>";
    } else {
        echo "<p class='error'>❌ خطا در ثبت temp: " . $connection->error . "</p>";
    }
} else {
    echo "<p class='error'>❌ خطا در ثبت فیش: " . $connection->error . "</p>";
}

// ریست step
$connection->query("UPDATE users SET step='none' WHERE userid={$test_user_id}");
echo "<p class='info'>🔄 Step به none برگشت</p>";

echo "</div>";

// مرحله 4: بررسی نهایی
echo "<div class='step'>";
echo "<h2>4️⃣ بررسی نهایی</h2>";

// چک pays
$pay_check = $connection->query("SELECT * FROM pays WHERE hash_id='{$hash_id}'");
if($pay_check && $pay_check->num_rows > 0){
    $pay_data = $pay_check->fetch_assoc();
    echo "<p class='success'>✅ رکورد در pays موجود است</p>";
    echo "<ul>";
    echo "<li>کاربر: {$pay_data['user_id']}</li>";
    echo "<li>مبلغ: " . number_format($pay_data['price']) . " تومان</li>";
    echo "<li>وضعیت: {$pay_data['state']}</li>";
    echo "<li>عکس: " . ($pay_data['photo'] ? 'دارد ✅' : 'ندارد ❌') . "</li>";
    echo "</ul>";
}

// چک temp
$temp_check = $connection->query("SELECT * FROM temp_service_purchases WHERE hash_id='{$hash_id}'");
if($temp_check && $temp_check->num_rows > 0){
    $temp_data = $temp_check->fetch_assoc();
    echo "<p class='success'>✅ رکورد در temp_service_purchases موجود است</p>";
    echo "<ul>";
    echo "<li>Plan ID: {$temp_data['plan_id']}</li>";
    echo "</ul>";
}

echo "</div>";

// مرحله 5: دکمه‌های تست
echo "<div class='step'>";
echo "<h2>5️⃣ تست کردن در ربات واقعی</h2>";
echo "<p>حالا می‌توانید این مراحل را در ربات واقعی تست کنید:</p>";
echo "<ol>";
echo "<li>به ربات برید: <a href='https://t.me/your_bot'>باز کردن ربات</a></li>";
echo "<li>دکمه <b>خرید سرویس APN</b> را بزنید</li>";
echo "<li>یک دسته انتخاب کنید</li>";
echo "<li>یک پلن انتخاب کنید</li>";
echo "<li>دکمه <b>پرداخت فیش بانکی</b> را بزنید</li>";
echo "<li>یک عکس دلخواه بفرستید</li>";
echo "</ol>";
echo "<p class='info'>📊 برای دیباگ: <a href='debug_live.php'>باز کردن debug_live.php</a></p>";
echo "</div>";

// نمایش callback برای تایید
echo "<div class='step'>";
echo "<h2>6️⃣ شبیه‌سازی تایید ادمین</h2>";
echo "<p class='info'>برای تست دستی callback تایید:</p>";
echo "<code>approveServicePayment_{$hash_id}</code>";
echo "<br><br>";
echo "<form method='POST' action='test_approve_payment.php'>";
echo "<input type='hidden' name='hash_id' value='{$hash_id}'>";
echo "<button type='submit'>✅ تست تایید پرداخت</button>";
echo "</form>";
echo "</div>";

echo "</body></html>";
?>
