<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>تست Include ها</h1>";

echo "<h2>1. تست config.php</h2>";
if(file_exists('config.php')) {
    echo "✅ فایل موجود است<br>";
    try {
        include_once 'config.php';
        echo "✅ لود شد<br>";
    } catch(Exception $e) {
        echo "❌ خطا: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ فایل وجود ندارد<br>";
}

echo "<h2>2. تست vip_plans_handler.php</h2>";
if(file_exists('vip_plans_handler.php')) {
    echo "✅ فایل موجود است<br>";
    try {
        include_once 'vip_plans_handler.php';
        echo "✅ لود شد<br>";
    } catch(Exception $e) {
        echo "❌ خطا: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ فایل وجود ندارد<br>";
}

echo "<h2>3. تست bot.php (خطوط اول)</h2>";
if(file_exists('bot.php')) {
    echo "✅ فایل موجود است<br>";
    $content = file_get_contents('bot.php');
    echo "حجم فایل: " . strlen($content) . " بایت<br>";
    echo "10 خط اول:<br><pre>";
    $lines = explode("\n", $content);
    for($i = 0; $i < 10 && $i < count($lines); $i++) {
        echo htmlspecialchars($lines[$i]) . "\n";
    }
    echo "</pre>";
} else {
    echo "❌ فایل وجود ندارد<br>";
}

echo "<h2>4. چک error_log</h2>";
if(file_exists('error_log')) {
    echo "✅ فایل error_log موجود است<br>";
    $errors = file_get_contents('error_log');
    $lines = explode("\n", $errors);
    $recent = array_slice($lines, -20);
    echo "<pre>";
    echo htmlspecialchars(implode("\n", $recent));
    echo "</pre>";
} else {
    echo "❌ فایل error_log وجود ندارد<br>";
}

echo "<h2>5. بررسی PHP Version</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "error_reporting: " . error_reporting() . "<br>";
echo "display_errors: " . ini_get('display_errors') . "<br>";

?>
