<?php
/**
 * تست اتصال به پنل با روش‌های مختلف
 */

echo "<h2>🔍 تست اتصال به پنل X-UI</h2>";
echo "<pre>";

// تنظیمات
$domain = 'apn.lotfischool.ir';
$ports = [2083, 54321, 2053, 443, 8443]; // پورت‌های رایج X-UI
$paths = [
    '/aHfvIoyNWcxlOfBfje/panel',
    '/panel',
    '/login'
];

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "🌐 دامنه: {$domain}\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

// تست DNS
echo "1️⃣ تست DNS:\n";
$ip = gethostbyname($domain);
if ($ip === $domain) {
    echo "   ❌ DNS resolve نشد!\n";
} else {
    echo "   ✅ IP: {$ip}\n";
}
echo "\n";

// تست پورت‌ها
echo "2️⃣ تست پورت‌ها:\n";
foreach ($ports as $port) {
    echo "   پورت {$port}: ";
    flush();
    
    $connection = @fsockopen($domain, $port, $errno, $errstr, 5);
    if ($connection) {
        echo "✅ باز است\n";
        fclose($connection);
    } else {
        echo "❌ بسته است ({$errstr})\n";
    }
}
echo "\n";

// تست URL های مختلف
echo "3️⃣ تست URL ها:\n";
foreach ($ports as $port) {
    foreach (['https', 'http'] as $protocol) {
        foreach (['/panel', '/aHfvIoyNWcxlOfBfje/panel'] as $path) {
            $url = "{$protocol}://{$domain}:{$port}{$path}";
            echo "   تست: {$url}\n";
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);
            
            if ($http_code == 200) {
                echo "      ✅ کد {$http_code} - پاسخ دریافت شد!\n";
                echo "      🎯 این URL کار می‌کند!\n\n";
                break 3;
            } elseif ($http_code > 0) {
                echo "      ⚠️ کد {$http_code}\n";
            } else {
                echo "      ❌ خطا: {$error}\n";
            }
        }
    }
}

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "💡 نکات:\n";
echo "1. اگر هیچ پورتی باز نیست، پنل خاموش است یا Firewall مسدود کرده\n";
echo "2. اگر پورتی باز است اما کد 200 نمی‌دهد، مسیر اشتباه است\n";
echo "3. معمولا پورت‌های 2053 یا 54321 در X-UI استفاده می‌شود\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

echo "</pre>";

// راهنما
echo "<h3>📋 راهنمای بررسی:</h3>";
echo "<ol>";
echo "<li>اگر DNS مشکل دارد: از IP مستقیم استفاده کنید</li>";
echo "<li>اگر همه پورت‌ها بسته است: پنل را روی سرور چک کنید</li>";
echo "<li>اگر پورتی باز است: URL صحیح را در فایل auto_account_creator.php قرار دهید</li>";
echo "</ol>";

echo "<h3>🔧 دستورات بررسی روی سرور:</h3>";
echo "<pre>";
echo "# چک کردن X-UI در حال اجرا است یا نه:\n";
echo "systemctl status x-ui\n\n";
echo "# مشاهده پورت X-UI:\n";
echo "netstat -tlnp | grep x-ui\n\n";
echo "# چک کردن فایروال:\n";
echo "ufw status\n";
echo "</pre>";
