<?php
/**
 * اسکریپت تست و دیباگ سیستم خرید
 * این فایل مشکلات رو پیدا می‌کنه و نشون میده
 */

require_once 'config.php';

echo "🔍 شروع تست سیستم خرید...\n\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

// 1. بررسی جداول
echo "📋 بررسی جداول:\n";

$tables = [
    'plan_categories',
    'service_plans',
    'service_orders',
    'temp_service_purchases',
    'servers'
];

$missing_tables = [];
foreach($tables as $table){
    $result = $connection->query("SHOW TABLES LIKE '{$table}'");
    if($result->num_rows > 0){
        echo "   ✅ جدول '{$table}' وجود دارد\n";
    } else {
        echo "   ❌ جدول '{$table}' وجود ندارد!\n";
        $missing_tables[] = $table;
    }
}
echo "\n";

if(!empty($missing_tables)){
    echo "⚠️ جداول زیر وجود ندارند:\n";
    foreach($missing_tables as $table){
        echo "   - {$table}\n";
    }
    echo "\n🔧 برای ایجاد جداول، فایل setup_purchase_system.php را اجرا کنید.\n\n";
    exit;
}

// 2. بررسی دیتا
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
echo "📊 بررسی دیتا:\n\n";

// دسته‌بندی‌ها
$stmt = $connection->prepare("SELECT * FROM `plan_categories` WHERE `status`='active'");
$stmt->execute();
$categories = $stmt->get_result();
$stmt->close();

echo "📦 دسته‌بندی‌های فعال ({$categories->num_rows}):\n";
if($categories->num_rows == 0){
    echo "   ❌ هیچ دسته‌بندی فعالی وجود ندارد!\n";
    echo "   💡 راه حل: فایل setup_purchase_system.php را اجرا کنید\n";
} else {
    while($cat = $categories->fetch_assoc()){
        echo "   ✅ {$cat['emoji']} {$cat['name']} (ID: {$cat['id']})\n";
    }
}
echo "\n";

// سرورها
$stmt = $connection->prepare("SELECT * FROM `servers` WHERE `status`='active'");
$stmt->execute();
$servers = $stmt->get_result();
$stmt->close();

echo "🖥️ سرورهای فعال ({$servers->num_rows}):\n";
if($servers->num_rows == 0){
    echo "   ❌ هیچ سرور فعالی وجود ندارد!\n";
    echo "   💡 راه حل: از پنل ادمین، بخش 'مدیریت سرورها' یک سرور اضافه کنید\n";
} else {
    while($server = $servers->fetch_assoc()){
        echo "   ✅ {$server['name']} - {$server['location']} (ID: {$server['id']})\n";
    }
}
echo "\n";

// پلن‌ها
$stmt = $connection->prepare("SELECT sp.*, pc.name as category_name, s.name as server_name 
                               FROM `service_plans` sp 
                               LEFT JOIN `plan_categories` pc ON sp.category_id = pc.id 
                               LEFT JOIN `servers` s ON sp.server_id = s.id 
                               WHERE sp.status='active'");
$stmt->execute();
$plans = $stmt->get_result();
$stmt->close();

echo "📋 پلن‌های فعال ({$plans->num_rows}):\n";
if($plans->num_rows == 0){
    echo "   ❌ هیچ پلن فعالی وجود ندارد!\n";
    echo "   💡 راه حل: فایل setup_purchase_system.php را اجرا کنید یا از پنل ادمین پلن اضافه کنید\n";
} else {
    while($plan = $plans->fetch_assoc()){
        $volume = $plan['volume_gb'] > 0 ? $plan['volume_gb'] . 'GB' : 'نامحدود';
        $price = number_format($plan['price']);
        $cat = $plan['category_name'] ?? 'بدون دسته';
        $srv = $plan['server_name'] ?? 'بدون سرور';
        echo "   ✅ {$plan['name']} ({$cat}) - {$volume}, {$plan['days']} روز, {$price} تومان (سرور: {$srv})\n";
    }
}
echo "\n";

// 3. تست Callback Data
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
echo "🧪 تست Callback Data:\n\n";

// شبیه‌سازی callback برای buyService
echo "1️⃣ تست 'buyService':\n";
$stmt = $connection->prepare("SELECT * FROM `plan_categories` WHERE `status`='active' ORDER BY `sort_order` ASC");
$stmt->execute();
$test_categories = $stmt->get_result();
$stmt->close();

if($test_categories->num_rows == 0){
    echo "   ❌ FAIL: هیچ دسته‌بندی‌ای برای نمایش وجود ندارد!\n";
} else {
    echo "   ✅ PASS: {$test_categories->num_rows} دسته‌بندی آماده نمایش است\n";
    echo "   📝 Callback Data های تولید شده:\n";
    while($cat = $test_categories->fetch_assoc()){
        echo "      - showPlansInCategory_{$cat['id']} ({$cat['name']})\n";
    }
}
echo "\n";

// تست برای اولین دسته
$stmt = $connection->prepare("SELECT * FROM `plan_categories` WHERE `status`='active' ORDER BY `sort_order` ASC LIMIT 1");
$stmt->execute();
$first_cat = $stmt->get_result()->fetch_assoc();
$stmt->close();

if($first_cat){
    $cat_id = $first_cat['id'];
    echo "2️⃣ تست 'showPlansInCategory_{$cat_id}':\n";
    
    $stmt = $connection->prepare("SELECT sp.*, s.name as server_name, s.location 
                                   FROM `service_plans` sp 
                                   JOIN `servers` s ON sp.server_id = s.id 
                                   WHERE sp.category_id = ? AND sp.status = 'active' AND s.status = 'active' 
                                   ORDER BY sp.price ASC");
    $stmt->bind_param("i", $cat_id);
    $stmt->execute();
    $test_plans = $stmt->get_result();
    $stmt->close();
    
    if($test_plans->num_rows == 0){
        echo "   ❌ FAIL: هیچ پلنی در دسته '{$first_cat['name']}' وجود ندارد!\n";
    } else {
        echo "   ✅ PASS: {$test_plans->num_rows} پلن در دسته '{$first_cat['name']}' موجود است\n";
        echo "   📝 Callback Data های تولید شده:\n";
        while($plan = $test_plans->fetch_assoc()){
            echo "      - buyPlan_{$plan['id']} ({$plan['name']})\n";
        }
    }
    echo "\n";
    
    // تست برای اولین پلن
    $stmt = $connection->prepare("SELECT sp.*, pc.name as category_name, s.name as server_name, s.location 
                                   FROM `service_plans` sp 
                                   JOIN `plan_categories` pc ON sp.category_id = pc.id 
                                   JOIN `servers` s ON sp.server_id = s.id 
                                   WHERE sp.category_id = ? AND sp.status = 'active' AND s.status = 'active' 
                                   ORDER BY sp.price ASC LIMIT 1");
    $stmt->bind_param("i", $cat_id);
    $stmt->execute();
    $first_plan = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if($first_plan){
        $plan_id = $first_plan['id'];
        echo "3️⃣ تست 'buyPlan_{$plan_id}':\n";
        echo "   ✅ PASS: اطلاعات پلن قابل نمایش است:\n";
        echo "      - نام: {$first_plan['name']}\n";
        echo "      - دسته: {$first_plan['category_name']}\n";
        echo "      - سرور: {$first_plan['server_name']}\n";
        echo "      - قیمت: " . number_format($first_plan['price']) . " تومان\n";
        echo "\n   📝 Callback Data های بعدی:\n";
        echo "      - payFromWallet_{$plan_id}\n";
        echo "      - payByReceipt_{$plan_id}\n";
    }
}

// 4. خلاصه نتیجه
echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
echo "📊 خلاصه نتیجه:\n\n";

$all_ok = true;
$issues = [];

if($categories->num_rows == 0){
    $all_ok = false;
    $issues[] = "هیچ دسته‌بندی فعالی وجود ندارد";
}

if($servers->num_rows == 0){
    $all_ok = false;
    $issues[] = "هیچ سرور فعالی وجود ندارد";
}

if($plans->num_rows == 0){
    $all_ok = false;
    $issues[] = "هیچ پلن فعالی وجود ندارد";
}

if($all_ok){
    echo "✅ همه چیز آماده است! سیستم خرید باید کار کنه.\n\n";
    echo "🎯 مراحل تست:\n";
    echo "   1. به ربات برید: /start\n";
    echo "   2. دکمه 'خرید سرویس APN' رو بزنید\n";
    echo "   3. یک دسته انتخاب کنید\n";
    echo "   4. یک پلن انتخاب کنید\n";
    echo "   5. روش پرداخت رو انتخاب کنید\n\n";
} else {
    echo "❌ مشکلات زیر باید برطرف بشن:\n\n";
    foreach($issues as $issue){
        echo "   ⚠️ {$issue}\n";
    }
    echo "\n";
    echo "🔧 راه حل:\n";
    echo "   1. فایل setup_purchase_system.php را اجرا کنید\n";
    echo "   2. یا از پنل ادمین ربات، سرور و پلن اضافه کنید\n\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
?>
