<?php
/**
 * فایل تست اتصال به پنل X-UI
 * این فایل را از مرورگر اجرا کنید تا از صحت اتصال اطمینان حاصل کنید
 */

require_once 'xui_api.php';

// تنظیمات پنل
$panel_url = 'https://apn.lotfischool.ir:2083/aHfvIoyNWcxlOfBfje/panel';
$username = 'parisa';
$password = '@230902Parisa';

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تست اتصال به پنل X-UI</title>
    <style>
        * {
            font-family: Tahoma, Arial, sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
            font-size: 28px;
        }
        .status {
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            font-size: 16px;
        }
        .success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }
        .info {
            background: #d1ecf1;
            border: 1px solid #bee5eb;
            color: #0c5460;
        }
        .warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
        }
        .inbound-list {
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        .inbound-item {
            padding: 10px;
            margin: 10px 0;
            background: white;
            border-left: 4px solid #667eea;
            border-radius: 5px;
        }
        .label {
            font-weight: bold;
            color: #667eea;
        }
        .loading {
            text-align: center;
            padding: 20px;
        }
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .config-info {
            background: #e9ecef;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            font-size: 14px;
        }
        .code {
            background: #f4f4f4;
            padding: 3px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            color: #c7254e;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔌 تست اتصال به پنل X-UI</h1>
        
        <div class="config-info">
            <div><span class="label">🌐 آدرس پنل:</span> <span class="code"><?php echo htmlspecialchars($panel_url); ?></span></div>
            <div style="margin-top: 10px;"><span class="label">👤 کاربری:</span> <span class="code"><?php echo htmlspecialchars($username); ?></span></div>
        </div>

        <?php
        echo '<div class="loading">';
        echo '<div class="spinner"></div>';
        echo '<p>در حال اتصال به پنل...</p>';
        echo '</div>';
        
        flush();
        ob_flush();
        
        // ایجاد شیء API
        $xui = new XUI_API($panel_url, $username, $password, true);
        
        // تست لاگین
        echo '<div class="status info">⏳ در حال ورود به پنل...</div>';
        flush();
        ob_flush();
        
        if ($xui->login()) {
            echo '<div class="status success">✅ ورود به پنل موفقیت‌آمیز بود!</div>';
            
            // دریافت لیست Inbound ها
            echo '<div class="status info">⏳ در حال دریافت لیست Inbound ها...</div>';
            flush();
            ob_flush();
            
            $inbounds = $xui->getInbounds();
            
            if ($inbounds && count($inbounds) > 0) {
                echo '<div class="status success">✅ تعداد ' . count($inbounds) . ' Inbound پیدا شد!</div>';
                
                echo '<div class="inbound-list">';
                echo '<h3>📋 لیست Inbound ها:</h3>';
                
                foreach ($inbounds as $inbound) {
                    $protocol = strtoupper($inbound['protocol']);
                    $highlight = ($protocol === 'VLESS') ? 'style="background: #d4edda;"' : '';
                    
                    echo '<div class="inbound-item" ' . $highlight . '>';
                    echo '<div><span class="label">🆔 شناسه:</span> ' . $inbound['id'] . '</div>';
                    echo '<div><span class="label">🔐 پروتکل:</span> ' . $protocol . '</div>';
                    echo '<div><span class="label">🔌 پورت:</span> ' . $inbound['port'] . '</div>';
                    if (isset($inbound['remark'])) {
                        echo '<div><span class="label">📝 نام:</span> ' . htmlspecialchars($inbound['remark']) . '</div>';
                    }
                    echo '</div>';
                }
                
                echo '</div>';
                
                // پیدا کردن VLESS Inbound
                echo '<div class="status info">⏳ در حال جستجوی Inbound با پروتکل VLESS...</div>';
                flush();
                ob_flush();
                
                $vless = $xui->findVlessInbound();
                
                if ($vless) {
                    echo '<div class="status success">✅ VLESS Inbound پیدا شد! (ID: ' . $vless['id'] . ')</div>';
                    echo '<div class="status success">🎉 همه چیز آماده است! می‌توانید از سیستم ساخت خودکار اکانت استفاده کنید.</div>';
                } else {
                    echo '<div class="status warning">⚠️ هیچ Inbound با پروتکل VLESS پیدا نشد!</div>';
                    echo '<div class="status info">💡 لطفا از پنل X-UI یک Inbound با پروتکل VLESS بسازید.</div>';
                }
                
            } else {
                echo '<div class="status warning">⚠️ هیچ Inbound پیدا نشد!</div>';
                echo '<div class="status info">💡 لطفا ابتدا از پنل X-UI یک Inbound بسازید.</div>';
            }
            
        } else {
            echo '<div class="status error">❌ خطا در ورود به پنل!</div>';
            echo '<div class="status error">لطفا موارد زیر را بررسی کنید:</div>';
            echo '<ul style="margin: 10px 0 10px 40px;">';
            echo '<li>یوزرنیم و پسورد صحیح باشد</li>';
            echo '<li>آدرس پنل درست وارد شده باشد</li>';
            echo '<li>پنل در دسترس باشد (از مرورگر تست کنید)</li>';
            echo '<li>SSL سرور مشکل نداشته باشد</li>';
            echo '</ul>';
            
            echo '<div class="status info">📄 برای جزئیات بیشتر فایل لاگ <code>xui_api_debug.log</code> را بررسی کنید.</div>';
        }
        
        echo '<div style="margin-top: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px; text-align: center;">';
        echo '<p style="color: #666;">تست در تاریخ: ' . date('Y/m/d H:i:s') . '</p>';
        echo '<p style="color: #666; margin-top: 10px;">برای تست مجدد صفحه را رفرش کنید.</p>';
        echo '</div>';
        ?>
    </div>
</body>
</html>
