<?php
/**
 * هندلر پلن‌های Trading / بازارهای مالی
 * کانفیگ‌های مخصوص ترید با پینگ پایین و سرعت بالا
 */

// پلن‌های Trading با قابلیت‌های ویژه - آی‌پی ثابت آلمان
$tradingPlans = [
    'trading1' => [
        'name' => '45 گیگ یک ماهه 📈',
        'volume' => 45,
        'days' => 30,
        'price' => 180000,
        'users' => 2,
        'ping' => '< 10ms',
        'speed' => 'فوق سریع',
        'description' => '📈 45 گیگ - یک ماهه (ویژه ترید)

👥 1-2 کاربر (2 دستگاه)
⚡️ پینگ بسیار پایین: < 10ms
🚀 سرعت فوق‌العاده بالا
🌍 لوکیشن: آلمان 🇩🇪 (آی‌پی ثابت)
💹 بهینه شده برای:
   • Binance, Bybit, OKX
   • TradingView
   • MetaTrader 4/5
   • بازارهای فارکس
📊 آپتایم 99.9%
✅ مناسب تست و شروع کار
💎 آی‌پی ثابت آلمان'
    ],
    'trading2' => [
        'name' => '130 گیگ سه ماهه 🏆',
        'volume' => 130,
        'days' => 90,
        'price' => 480000,
        'users' => 2,
        'ping' => '< 10ms',
        'speed' => 'فوق سریع',
        'description' => '🏆 130 گیگ - سه ماهه (اقتصادی)

👥 1-2 کاربر (2 دستگاه)
⚡️ پینگ فوق پایین: < 10ms
🚀 سرعت فوق سریع
🌍 لوکیشن: آلمان 🇩🇪 (آی‌پی ثابت)
💹 انتخاب اقتصادی برای تریدرهای فعال
📊 پشتیبانی VIP
✅ صرفه‌جویی در هزینه
💎 آی‌پی ثابت آلمان'
    ],
    'trading3' => [
        'name' => '260 گیگ شش ماهه 💎',
        'volume' => 260,
        'days' => 180,
        'price' => 900000,
        'users' => 2,
        'ping' => '< 10ms',
        'speed' => 'فوق سریع',
        'description' => '💎 260 گیگ - شش ماهه (بهترین ارزش)

👥 1-2 کاربر (2 دستگاه)
⚡️ پینگ: < 10ms
🚀 سرعت فوق سریع
🌍 لوکیشن: آلمان 🇩🇪 (آی‌پی ثابت)
💹 بهترین ارزش، حجم و مدت طولانی
📊 Priority Support
✅ گارانتی اتصال پایدار
🎁 بیشترین صرفه‌جویی
💎 آی‌پی ثابت آلمان'
    ]
];

// چک کردن وضعیت فروش پلن‌ها
function isTradingPlanEnabled($planKey) {
    global $connection;
    
    $stmt = $connection->prepare("SELECT `enabled` FROM `trading_plans_status` WHERE `plan_key` = ?");
    $stmt->bind_param("s", $planKey);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($row = $result->fetch_assoc()) {
        return $row['enabled'] == 1;
    }
    
    // اگر رکوردی نبود، پیش‌فرض فعال است
    return true;
}

// فیلتر کردن پلن‌های فعال
function getActiveTradingPlans() {
    global $tradingPlans;
    
    $activePlans = [];
    foreach($tradingPlans as $key => $plan) {
        if(isTradingPlanEnabled($key)) {
            $activePlans[$key] = $plan;
        }
    }
    
    return $activePlans;
}

// نمایش لیست پلن‌های Trading
if($data == 'tradingPlans'){
    delMessage();
    
    $activePlans = getActiveTradingPlans();
    
    if(empty($activePlans)) {
        $message = "⚠️ <b>در حال حاضر پلنی برای فروش موجود نیست</b>

━━━━━━━━━━━━━━━━━━━━━━

📈 <b>پلن‌های Trading</b>

💹 پلن‌های مخصوص ترید به زودی در دسترس قرار می‌گیرند.

🔔 برای اطلاع از راه‌اندازی با پشتیبانی تماس بگیرید.";
        
        $keyboard = [];
        $keyboard[] = [['text' => '📞 پشتیبانی', 'callback_data' => 'supportSection']];
        $keyboard[] = [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'mainMenu']];
        
        sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
        exit;
    }
    
    $message = "📊 <b>پلن‌های آی‌پی ثابت آلمان (ویژه ترید)</b>

━━━━━━━━━━━━━━━━━━━━━━

🇩🇪 <b>آی‌پی ثابت آلمان</b>
⚡️ پینگ پایین - مناسب ترید
💹 بهینه برای Binance، Bybit، OKX
📈 پشتیبانی MetaTrader و TradingView

━━━━━━━━━━━━━━━━━━━━━━

<b>پلن‌های موجود:</b>\n\n";
    
    $planDetails = [
        'trading1' => "📦 یک ماهه: 45 گیگ | 1-2 کاربر | 180,000 تومان\n   ✅ مناسب تست و شروع کار",
        'trading2' => "📦 سه ماهه: 130 گیگ | 1-2 کاربر | 480,000 تومان\n   ✅ انتخاب اقتصادی برای تریدرهای فعال",
        'trading3' => "📦 شش ماهه: 260 گیگ | 1-2 کاربر | 900,000 تومان\n   ✅ بهترین ارزش، حجم و مدت طولانی"
    ];
    
    foreach($activePlans as $key => $plan) {
        if(isset($planDetails[$key])) {
            $message .= $planDetails[$key] . "\n\n";
        }
    }
    
    $message .= "━━━━━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "💎 همه پلن‌ها با آی‌پی ثابت آلمان\n";
    $message .= "✨ برای جزئیات بیشتر روی پلن کلیک کنید";
    
    $keyboard = [];
    
    foreach($activePlans as $key => $plan) {
        $keyboard[] = [['text' => $plan['name'], 'callback_data' => 'selectTradingPlan_' . $key]];
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'mainMenu']];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// انتخاب پلن Trading و نمایش جزئیات
if(preg_match('/^selectTradingPlan_(.+)$/', $data, $match)){
    $planKey = $match[1];
    
    if(!isset($tradingPlans[$planKey])){
        alert("پلن یافت نشد!");
        exit;
    }
    
    // چک کردن دسترسی به پلن
    if(!isTradingPlanEnabled($planKey)) {
        alert("⚠️ این پلن در حال حاضر برای فروش در دسترس نیست!");
        exit;
    }
    
    $plan = $tradingPlans[$planKey];
    
    $message = "📦 <b>{$plan['name']}</b>

━━━━━━━━━━━━━━━━━━━━━━

{$plan['description']}

━━━━━━━━━━━━━━━━━━━━━━

💰 <b>قیمت: " . number_format($plan['price']) . " تومان</b>

⚠️ <b>توجه:</b> این سرویس در حال راه‌اندازی است.
برای خرید با پشتیبانی تماس بگیرید.";
    
    $keyboard = [];
    $keyboard[] = [['text' => '🔔 اطلاع‌رسانی راه‌اندازی', 'callback_data' => 'notifyMeTrading_' . $planKey]];
    $keyboard[] = [['text' => '📞 تماس با پشتیبانی', 'callback_data' => 'supportSection']];
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'tradingPlans']];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// ثبت درخواست اطلاع‌رسانی
if(preg_match('/^notifyMeTrading_(.+)$/', $data, $match)){
    $planKey = $match[1];
    
    if(!isset($tradingPlans[$planKey])){
        alert("پلن یافت نشد!");
        exit;
    }
    
    $plan = $tradingPlans[$planKey];
    
    // ذخیره در دیتابیس (در جدول موجود یا جدید)
    $stmt = $connection->prepare("INSERT INTO `setting` (`type`, `value`) VALUES (?, ?) ON DUPLICATE KEY UPDATE `value` = CONCAT(`value`, ',', ?)");
    $type_key = "TRADING_NOTIFY_{$planKey}";
    $stmt->bind_param("sss", $type_key, $from_id, $from_id);
    $stmt->execute();
    $stmt->close();
    
    alert("✅ ثبت شد! به محض راه‌اندازی، به شما اطلاع داده می‌شود.");
    
    // ارسال به ادمین
    sendMessage("🔔 درخواست جدید برای پلن Trading

👤 کاربر: {$from_id}
📦 پلن: {$plan['name']}
⏰ تاریخ: " . jdate('Y/m/d H:i'), null, 'HTML', $admin);
    
    exit;
}

// پنل مدیریت فروش پلن‌های Trading (فقط ادمین)
if($data == 'manageTradingSales' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    delMessage();
    
    $message = "⚙️ <b>مدیریت فروش پلن‌های Trading</b>

━━━━━━━━━━━━━━━━━━━━━━

📊 وضعیت فروش پلن‌ها:\n\n";
    
    foreach($tradingPlans as $key => $plan) {
        $enabled = isTradingPlanEnabled($key);
        $status = $enabled ? "✅ فعال" : "❌ غیرفعال";
        $message .= "• {$plan['name']}: {$status}\n";
    }
    
    $message .= "\n━━━━━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "💡 برای تغییر وضعیت، روی پلن مورد نظر کلیک کنید.";
    
    $keyboard = [];
    
    foreach($tradingPlans as $key => $plan) {
        $enabled = isTradingPlanEnabled($key);
        $icon = $enabled ? "✅" : "❌";
        $keyboard[] = [['text' => "{$icon} {$plan['name']}", 'callback_data' => 'toggleTradingPlan_' . $key]];
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت به پنل ادمین', 'callback_data' => 'adminSection']];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// تغییر وضعیت فروش پلن (فقط ادمین)
if(preg_match('/^toggleTradingPlan_(.+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $planKey = $match[1];
    
    if(!isset($tradingPlans[$planKey])){
        alert("پلن یافت نشد!");
        exit;
    }
    
    // چک کردن وضعیت فعلی
    $stmt = $connection->prepare("SELECT `enabled` FROM `trading_plans_status` WHERE `plan_key` = ?");
    $stmt->bind_param("s", $planKey);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($row = $result->fetch_assoc()) {
        // تغییر وضعیت
        $newStatus = $row['enabled'] == 1 ? 0 : 1;
        $stmt = $connection->prepare("UPDATE `trading_plans_status` SET `enabled` = ? WHERE `plan_key` = ?");
        $stmt->bind_param("is", $newStatus, $planKey);
        $stmt->execute();
    } else {
        // درج رکورد جدید (پیش‌فرض غیرفعال می‌کنیم)
        $newStatus = 0;
        $stmt = $connection->prepare("INSERT INTO `trading_plans_status` (`plan_key`, `enabled`) VALUES (?, ?)");
        $stmt->bind_param("si", $planKey, $newStatus);
        $stmt->execute();
    }
    
    $statusText = $newStatus == 1 ? "فعال" : "غیرفعال";
    alert("✅ وضعیت پلن {$tradingPlans[$planKey]['name']} به {$statusText} تغییر یافت!");
    
    // بازخوانی صفحه مدیریت
    $message = "⚙️ <b>مدیریت فروش پلن‌های Trading</b>

━━━━━━━━━━━━━━━━━━━━━━

📊 وضعیت فروش پلن‌ها:\n\n";
    
    foreach($tradingPlans as $key => $plan) {
        $enabled = isTradingPlanEnabled($key);
        $status = $enabled ? "✅ فعال" : "❌ غیرفعال";
        $message .= "• {$plan['name']}: {$status}\n";
    }
    
    $message .= "\n━━━━━━━━━━━━━━━━━━━━━━\n\n";
    $message .= "💡 برای تغییر وضعیت، روی پلن مورد نظر کلیک کنید.";
    
    $keyboard = [];
    
    foreach($tradingPlans as $key => $plan) {
        $enabled = isTradingPlanEnabled($key);
        $icon = $enabled ? "✅" : "❌";
        $keyboard[] = [['text' => "{$icon} {$plan['name']}", 'callback_data' => 'toggleTradingPlan_' . $key]];
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت به پنل ادمین', 'callback_data' => 'adminSection']];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// فعال‌سازی پلن‌های Trading (فقط ادمین) - برای آینده
if($data == 'activateTradingPlans' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    // TODO: فعال‌سازی سیستم خرید واقعی
    sendMessage("⚙️ این بخش در حال توسعه است و به زودی فعال می‌شود.", getAdminKeys());
    exit;
}
?>
