<?php
/**
 * بروزرسانی ساختار جداول تخفیف
 * این اسکریپت ساختار قدیمی را به ساختار جدید تبدیل می‌کند
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

include "baseInfo.php";

echo "<pre>";
echo "=== بروزرسانی جداول سیستم تخفیف ===\n\n";

$connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
if($connection->connect_error){
    die("❌ خطا در اتصال: " . $connection->connect_error);  
}

echo "✅ اتصال به دیتابیس موفق\n\n";
$connection->set_charset("utf8mb4");

// مرحله 1: ایجاد جدول جدید با ساختار صحیح
echo "📌 مرحله 1: ایجاد جدول جدید discounts_new...\n";
$sql = "CREATE TABLE IF NOT EXISTS `discounts_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL UNIQUE,
  `type` ENUM('percent', 'fixed') NOT NULL DEFAULT 'percent',
  `amount` int(11) NOT NULL,
  `max_use` int(11) DEFAULT 0 COMMENT '0 = نامحدود',
  `used_count` int(11) DEFAULT 0,
  `expire_date` int(11) DEFAULT NULL,
  `status` ENUM('active', 'inactive') DEFAULT 'active',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_code` (`code`),
  INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if($connection->query($sql)){
    echo "✅ جدول discounts_new ایجاد شد\n\n";
} else {
    echo "❌ خطا: " . $connection->error . "\n";
}

// مرحله 2: انتقال داده‌ها از جدول قدیمی
echo "📌 مرحله 2: انتقال داده‌های موجود...\n";
$check = $connection->query("SELECT * FROM `discounts`");
if($check && $check->num_rows > 0){
    while($old = $check->fetch_assoc()){
        // تبدیل hash_id به code
        $code = isset($old['hash_id']) ? $old['hash_id'] : (isset($old['code']) ? $old['code'] : '');
        $type = $old['type'];
        $amount = $old['amount'];
        
        // تبدیل expire_count به max_use
        $max_use = isset($old['expire_count']) ? $old['expire_count'] : (isset($old['max_use']) ? $old['max_use'] : 0);
        
        // محاسبه used_count از used_by
        $used_count = 0;
        if(isset($old['used_by']) && !empty($old['used_by'])){
            $used_count = count(explode(',', $old['used_by']));
        } else if(isset($old['used_count'])){
            $used_count = $old['used_count'];
        }
        
        $expire_date = isset($old['expire_date']) ? $old['expire_date'] : NULL;
        
        // تبدیل can_use به status
        $status = 'active';
        if(isset($old['can_use'])){
            $status = $old['can_use'] == 1 ? 'active' : 'inactive';
        } else if(isset($old['status'])){
            $status = $old['status'];
        }
        
        $stmt = $connection->prepare("INSERT INTO `discounts_new` (`code`, `type`, `amount`, `max_use`, `used_count`, `expire_date`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssiiiis", $code, $type, $amount, $max_use, $used_count, $expire_date, $status);
        
        if($stmt->execute()){
            echo "✅ کد تخفیف {$code} منتقل شد\n";
        } else {
            echo "⚠️ خطا در انتقال {$code}: " . $stmt->error . "\n";
        }
        $stmt->close();
    }
    echo "\n";
} else {
    echo "ℹ️ هیچ داده‌ای در جدول قدیمی وجود ندارد\n\n";
}

// مرحله 3: جایگزینی جداول
echo "📌 مرحله 3: جایگزینی جدول قدیمی با جدید...\n";
$connection->query("DROP TABLE IF EXISTS `discounts_old`");
$connection->query("RENAME TABLE `discounts` TO `discounts_old`");
$connection->query("RENAME TABLE `discounts_new` TO `discounts`");
echo "✅ جدول قدیمی به discounts_old تغییر نام داد و جدول جدید جایگزین شد\n\n";

// مرحله 4: ایجاد جدول discount_usage
echo "📌 مرحله 4: ایجاد جدول discount_usage...\n";
$sql = "CREATE TABLE IF NOT EXISTS `discount_usage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `discount_id` int(11) NOT NULL,
  `plan_id` int(11) NOT NULL DEFAULT 0,
  `discount_amount` int(11) NOT NULL,
  `used_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_user_discount` (`user_id`, `discount_id`),
  INDEX `idx_discount` (`discount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if($connection->query($sql)){
    echo "✅ جدول discount_usage ایجاد شد\n\n";
} else {
    echo "❌ خطا: " . $connection->error . "\n";
}

// مرحله 5: انتقال داده‌های استفاده از used_by به discount_usage
echo "📌 مرحله 5: انتقال سابقه استفاده کاربران...\n";
$old_discounts = $connection->query("SELECT * FROM `discounts_old`");
if($old_discounts && $old_discounts->num_rows > 0){
    while($old = $old_discounts->fetch_assoc()){
        if(!empty($old['used_by'])){
            $users = explode(',', $old['used_by']);
            
            // پیدا کردن id جدید این تخفیف
            $code = $old['hash_id'];
            $new_discount = $connection->query("SELECT `id` FROM `discounts` WHERE `code` = '$code'");
            if($new_discount && $new_discount->num_rows > 0){
                $new_id = $new_discount->fetch_assoc()['id'];
                
                foreach($users as $user_id){
                    $user_id = trim($user_id);
                    if(!empty($user_id)){
                        // محاسبه تخفیف (تقریبی)
                        $discount_amount = $old['type'] == 'fixed' ? $old['amount'] : 0;
                        
                        $stmt = $connection->prepare("INSERT INTO `discount_usage` (`user_id`, `discount_id`, `plan_id`, `discount_amount`) VALUES (?, ?, 0, ?)");
                        $stmt->bind_param("iii", $user_id, $new_id, $discount_amount);
                        $stmt->execute();
                        $stmt->close();
                    }
                }
                echo "✅ سابقه استفاده از کد {$code} منتقل شد (" . count($users) . " کاربر)\n";
            }
        }
    }
    echo "\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ <b>بروزرسانی با موفقیت انجام شد!</b>\n\n";
echo "تغییرات اعمال شده:\n";
echo "  • hash_id → code\n";
echo "  • can_use → status (active/inactive)\n";
echo "  • expire_count → max_use\n";
echo "  • used_by → used_count + جدول discount_usage\n\n";
echo "جدول قدیمی با نام discounts_old ذخیره شده است\n";
echo "در صورت بروز مشکل می‌توانید آن را بازگردانید.\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

$connection->close();
?>
